/*
 * Decompiled with CFR 0.152.
 */
package ch.rfin.util;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

public final class Pair<T1, T2> {
    public final T1 _1;
    public final T2 _2;

    private Pair(T1 first, T2 second) {
        this._1 = first;
        this._2 = second;
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    public static <T> Pair<T, T> of(T both) {
        return new Pair<T, T>(both, both);
    }

    public static <T1, T2> Pair<T1, T2> pair(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    public static <T> Pair<T, T> pair(T both) {
        return new Pair<T, T>(both, both);
    }

    public T1 get_1() {
        return this._1;
    }

    public T2 get_2() {
        return this._2;
    }

    public <U> Pair<U, T2> with_1(U newFirst) {
        return Pair.of(newFirst, this._2);
    }

    public <U> Pair<T1, U> with_2(U newSecond) {
        return Pair.of(this._1, newSecond);
    }

    public Pair<T2, T1> swap() {
        return Pair.of(this._2, this._1);
    }

    public <U> Pair<U, T2> map_1(Function<? super T1, ? extends U> f) {
        return Pair.of(f.apply(this._1), this._2);
    }

    public <U> Pair<T1, U> map_2(Function<? super T2, ? extends U> f) {
        return Pair.of(this._1, f.apply(this._2));
    }

    public <U, R> Pair<U, R> map(Function<? super T1, ? extends U> f, Function<? super T2, ? extends R> g) {
        return Pair.of(f.apply(this._1), g.apply(this._2));
    }

    public <R> R apply(BiFunction<? super T1, ? super T2, ? extends R> f) {
        return f.apply(this._1, this._2);
    }

    public boolean test(BiPredicate<? super T1, ? super T2> p) {
        return p.test(this._1, this._2);
    }

    public void accept(BiConsumer<? super T1, ? super T2> c) {
        c.accept(this._1, this._2);
    }

    public String toString() {
        return "(" + this._1 + ", " + this._2 + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Pair that = (Pair)o;
        return Objects.deepEquals(this._1, that._1) && Objects.deepEquals(this._2, that._2);
    }

    public int hashCode() {
        return Objects.hash(this._1, this._2);
    }
}

