/*
 * Decompiled with CFR 0.152.
 */
package ch.rfin.util;

import ch.rfin.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class Pairs {
    private Pairs() {
    }

    public static <K, V> Pair<K, V> pairFrom(Map.Entry<K, V> entry) {
        return Pair.of(entry.getKey(), entry.getValue());
    }

    public static <T> Pair<T, T> pairFrom(List<T> xs) {
        return Pair.of(xs.get(0), xs.get(1));
    }

    @Deprecated(forRemoval=true)
    public static <T> List<Pair<T, T>> pairs(List<T> items) {
        int len = items.size();
        if (len == 0) {
            return Collections.emptyList();
        }
        if (len % 2 != 0) {
            throw new IllegalArgumentException(len + " is not an even number of items");
        }
        ArrayList<Pair<T, T>> result = new ArrayList<Pair<T, T>>(len / 2);
        for (int i = 1; i < len; i += 2) {
            result.add(Pair.of(items.get(i - 1), items.get(i)));
        }
        return result;
    }

    public static <T> List<Pair<T, T>> pairsFrom(Iterable<T> xs) {
        return Pairs.stream(xs).collect(Collectors.toList());
    }

    @Deprecated(forRemoval=true)
    public static <K, V> List<Pair<K, V>> pairs(Map<K, V> items) {
        return Pairs.pairsFrom(items);
    }

    public static <K, V> List<Pair<K, V>> pairsFrom(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        return Pairs.stream(map).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> toMap(Iterable<Pair<K, V>> items) {
        HashMap map = new HashMap();
        items.forEach(p -> p.accept(map::put));
        return map;
    }

    public static <T> Stream<Pair<T, T>> stream(Iterable<T> xs) {
        Iterator it = xs.iterator();
        if (!it.hasNext()) {
            return Stream.empty();
        }
        return Stream.generate(() -> {
            Object first = it.hasNext() ? (Object)it.next() : null;
            Object second = it.hasNext() ? (Object)it.next() : null;
            return first != null && second != null ? Pair.of(first, second) : null;
        }).takeWhile(x -> x != null);
    }

    public static <T> Stream<Pair<T, T>> streamAdjacent(Iterable<T> xs) {
        final Iterator<T> it = xs.iterator();
        Iterator pairs = new Iterator<Pair<T, T>>(){
            T first = null;

            @Override
            public boolean hasNext() {
                throw new AssertionError((Object)"Should not be called!");
            }

            @Override
            public Pair<T, T> next() {
                Object second;
                if (this.first == null) {
                    this.first = it.hasNext() ? it.next() : null;
                }
                Object T2 = second = it.hasNext() ? (Object)it.next() : null;
                if (this.first == null || second == null) {
                    return null;
                }
                Pair result = Pair.of(this.first, second);
                this.first = second;
                return result;
            }
        };
        if (!it.hasNext()) {
            return Stream.empty();
        }
        return Stream.generate(pairs::next).takeWhile(x -> x != null);
    }

    public static <K, V> Stream<Pair<K, V>> stream(Map<K, V> map) {
        if (map.isEmpty()) {
            return Stream.empty();
        }
        return map.entrySet().stream().map(Pairs::pairFrom);
    }

    public static <T> Stream<Pair<Integer, T>> enumerate(Iterable<T> xs) {
        Iterator it = xs.iterator();
        if (!it.hasNext()) {
            return Stream.empty();
        }
        return IntStream.range(0, Integer.MAX_VALUE).boxed().takeWhile(i -> it.hasNext()).map(Pairs.withId(i -> it.next()));
    }

    public static <T1, T2> Collector<Pair<T1, T2>, ?, Map<T1, T2>> pairsToMap() {
        return Collectors.toMap(Pair::get_1, Pair::get_2);
    }

    public static <T1, T2> Stream<Pair<T1, T2>> zip(Iterable<T1> xs, Iterable<T2> ys) {
        Iterator it1 = xs.iterator();
        Iterator it2 = ys.iterator();
        if (!it1.hasNext() || !it2.hasNext()) {
            return Stream.empty();
        }
        return Stream.generate(() -> it1.hasNext() && it2.hasNext() ? Pair.of(it1.next(), it2.next()) : null).takeWhile(x -> x != null);
    }

    public static <T1, T2, R> Function<Pair<T1, T2>, R> function(BiFunction<? super T1, ? super T2, ? extends R> f) {
        return p -> f.apply((Object)p._1, (Object)p._2);
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> biFunction(Function<Pair<T1, T2>, ? extends R> f) {
        return (a, b) -> f.apply(Pair.of(a, b));
    }

    public static <T1, T2> Predicate<Pair<T1, T2>> predicate(BiPredicate<? super T1, ? super T2> f) {
        return p -> f.test((Object)p._1, (Object)p._2);
    }

    public static <T1, T2> BiPredicate<T1, T2> biPredicate(Predicate<Pair<T1, T2>> f) {
        return (a, b) -> f.test(Pair.of(a, b));
    }

    public static <T1, T2> Consumer<Pair<T1, T2>> consumer(BiConsumer<? super T1, ? super T2> f) {
        return p -> f.accept((Object)p._1, (Object)p._2);
    }

    public static <T1, T2> BiConsumer<T1, T2> biConsumer(Consumer<Pair<T1, T2>> f) {
        return (a, b) -> f.accept(Pair.of(a, b));
    }

    public static <T, R> Function<T, Pair<T, R>> withId(Function<? super T, ? extends R> f) {
        return x -> Pair.of(x, f.apply(x));
    }

    public static <T1 extends Comparable<? super T1>, T2 extends Comparable<? super T2>> Comparator<Pair<T1, T2>> comparator() {
        return Comparator.comparing(p -> (Comparable)p._1).thenComparing(p -> (Comparable)p._2);
    }

    public static <T1 extends Comparable<? super T1>, T2 extends Comparable<? super T2>> int compare(Pair<T1, T2> p1, Pair<T1, T2> p2) {
        return Pairs.comparator().compare(p1, p2);
    }

    public static <T1, T2> Function<T2, Pair<T1, T2>> pairWithFirst(T1 first) {
        return s -> Pair.of(first, s);
    }

    public static <T1, T2> Function<T1, Pair<T1, T2>> pairWithSecond(T2 second) {
        return t -> Pair.of(t, second);
    }

    public static <T1, T2, R> Function<Pair<T1, T2>, Pair<R, T2>> map_1(Function<? super T1, ? extends R> f) {
        return p -> p.map_1(f);
    }

    public static <T1, T2, R> Function<Pair<T1, T2>, Pair<T1, R>> map_2(Function<? super T2, ? extends R> f) {
        return p -> p.map_2(f);
    }

    public static <T1, T2, R, U> Function<Pair<T1, T2>, Pair<R, U>> map(Function<? super T1, ? extends R> f, Function<? super T2, ? extends U> g) {
        return p -> p.map(f, g);
    }

    public static <T1, T2> Predicate<Pair<T1, T2>> test_1(Predicate<? super T1> f) {
        return p -> f.test((Object)p._1);
    }

    public static <T1, T2> Predicate<Pair<T1, T2>> test_2(Predicate<? super T2> f) {
        return p -> f.test((Object)p._2);
    }
}

