/*
 * Decompiled with CFR 0.152.
 */
package ch.rfin.util;

import java.util.Collection;
import java.util.function.IntPredicate;
import java.util.function.Predicate;

public class Predicates {
    public static Predicate<String> emptyString() {
        return s -> s == null || s.length() == 0;
    }

    public static boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    public static <T> Predicate<Collection<T>> emptyCollection() {
        return c -> c == null || c.isEmpty();
    }

    public static <T> boolean empty(Collection<T> c) {
        return c == null || c.isEmpty();
    }

    public static Predicate<Object> isNull() {
        return o -> o == null;
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static Predicate<Object> nonNull() {
        return o -> o != null;
    }

    public static boolean nonNull(Object o) {
        return o != null;
    }

    public static boolean zero(int i) {
        return i == 0;
    }

    public static boolean positive(int i) {
        return i > 0;
    }

    public static boolean negative(int i) {
        return i < 0;
    }

    public static Predicate<Integer> zero() {
        return i -> i == 0;
    }

    public static Predicate<Integer> positive() {
        return i -> i > 0;
    }

    public static Predicate<Integer> negative() {
        return i -> i < 0;
    }

    public static Predicate<Integer> lessThan(Integer n) {
        return i -> i < n;
    }

    public static Predicate<Integer> greaterThan(Integer n) {
        return i -> i > n;
    }

    public static Predicate<Integer> atLeast(Integer n) {
        return i -> i >= n;
    }

    public static Predicate<Integer> atMost(Integer n) {
        return i -> i <= n;
    }

    public static Predicate<Integer> between(Integer min, Integer max) {
        return i -> min <= i && i <= max;
    }

    public static Predicate<Integer> outside(Integer min, Integer max) {
        return i -> i < min || i > max;
    }

    public static <T extends Comparable<? super T>> Predicate<T> lessThan(T b) {
        return a -> a.compareTo(b) < 0;
    }

    public static <T extends Comparable<? super T>> Predicate<T> atMost(T b) {
        return a -> a.compareTo(b) <= 0;
    }

    public static <T extends Comparable<? super T>> Predicate<T> greaterThan(T b) {
        return a -> a.compareTo(b) > 0;
    }

    public static <T extends Comparable<? super T>> Predicate<T> atLeast(T b) {
        return a -> a.compareTo(b) >= 0;
    }

    public static <T extends Comparable<? super T>> Predicate<T> between(T min, T max) {
        return Predicates.atLeast(min).and(Predicates.atMost(max));
    }

    public static <T extends Comparable<? super T>> Predicate<T> outside(T min, T max) {
        return Predicates.between(min, max).negate();
    }

    public static class Primitive {
        public static boolean zero(int n) {
            return n == 0;
        }

        public static boolean positive(int n) {
            return n > 0;
        }

        public static boolean negative(int n) {
            return n < 0;
        }

        public static IntPredicate zero() {
            return i -> i == 0;
        }

        public static IntPredicate positive() {
            return i -> i > 0;
        }

        public static IntPredicate negative() {
            return i -> i < 0;
        }

        public static IntPredicate lessThan(int n) {
            return i -> i < n;
        }

        public static IntPredicate atMost(int n) {
            return i -> i <= n;
        }

        public static IntPredicate greaterThan(int n) {
            return i -> i > n;
        }

        public static IntPredicate atLeast(int n) {
            return i -> i >= n;
        }

        public static IntPredicate between(int min, int max) {
            return i -> min <= i && i <= max;
        }

        public static IntPredicate outside(int min, int max) {
            return i -> i < min || i > max;
        }
    }
}

