/*
 * Decompiled with CFR 0.152.
 */
package ch.rotscher.maven.plugins;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugin.dependency.fromConfiguration.CopyMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class DeployDependencyMojo
extends CopyMojo {
    private MavenProjectHelper projectHelper;
    private boolean artifactIdAsClassifier;
    private boolean preserveClassifier;

    public void execute() throws MojoExecutionException {
        super.execute();
        MavenProject project = this.getProject();
        if (!this.artifactIdAsClassifier && this.hasMoreThanOneArtifacts(super.getArtifactItems())) {
            this.getLog().warn((CharSequence)"your configuration of artifactIdAsClassifier is overriden and set to true as there is more than one artifactItem configured");
            this.artifactIdAsClassifier = true;
        }
        if (!this.preserveClassifier && this.hasMoreThanOneArtifacts(super.getArtifactItems())) {
            this.getLog().warn((CharSequence)"your configuration of preserveClassifier is overriden and set to true as there is more than one artifactItem configured");
            this.preserveClassifier = true;
        }
        for (ArtifactItem each : super.getArtifactItems()) {
            String newClassifier = "";
            if (this.artifactIdAsClassifier) {
                newClassifier = each.getArtifact().getArtifactId();
            }
            if (this.preserveClassifier && each.getArtifact().getClassifier() != null) {
                newClassifier = newClassifier.length() > 0 ? newClassifier + "-" + each.getArtifact().getClassifier() : each.getArtifact().getClassifier();
            }
            this.projectHelper.attachArtifact(project, each.getArtifact().getType(), newClassifier, each.getArtifact().getFile());
        }
    }

    private boolean hasMoreThanOneArtifacts(List<?> artifactsItems) {
        return artifactsItems.size() > 1;
    }
}

