/*
 * Decompiled with CFR 0.152.
 */
package ch.rotscher.maven.plugins;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.install.InstallMojo;
import org.apache.maven.project.MavenProject;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class InstallWithVersionOverrideMojo
extends InstallMojo {
    public void execute() throws MojoExecutionException {
        try {
            String versionOverride = System.getProperty("version.override");
            if (versionOverride != null) {
                MavenProject project = this.getMavenProject();
                if (project != null) {
                    this.getLog().info((CharSequence)"version.override: rewrite the version in the original pom.xom in target/pom.xml");
                    File targetDir = new File(project.getBasedir(), "target");
                    if (!targetDir.exists()) {
                        targetDir.mkdir();
                    }
                    File newPomFile = new File(targetDir, "pom.xml");
                    newPomFile.createNewFile();
                    this.replaceVersion(project.getFile(), newPomFile, versionOverride);
                    project.setFile(newPomFile);
                } else {
                    this.getLog().warn((CharSequence)"could not access the project in InstallMojo: install with version.override did not work!");
                }
            }
        }
        catch (IOException e) {
            this.getLog().warn((Throwable)e);
        }
        catch (JDOMException e) {
            this.getLog().warn((Throwable)e);
        }
        super.execute();
    }

    private void replaceVersion(File originalPomFile, File newPomFile, String newVersion) throws IOException, JDOMException {
        FileWriter writer = new FileWriter(newPomFile);
        SAXBuilder parser = new SAXBuilder();
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        Document doc = parser.build(originalPomFile);
        Element versionElem = this.findVersionElement(doc);
        versionElem.setText(newVersion);
        xmlOutput.output(doc, (Writer)writer);
        writer.flush();
        writer.close();
    }

    private Element findVersionElement(Document doc) {
        for (Element element : doc.getRootElement().getChildren()) {
            if (!element.getName().equals("version")) continue;
            return element;
        }
        for (Element element : doc.getRootElement().getChildren()) {
            if (!element.getName().equals("parent")) continue;
            for (Element childElem : element.getChildren()) {
                if (!childElem.getName().equals("version")) continue;
                return childElem;
            }
        }
        return null;
    }

    private MavenProject getMavenProject() {
        try {
            Field privateStringField = InstallMojo.class.getDeclaredField("project");
            privateStringField.setAccessible(true);
            return (MavenProject)privateStringField.get((Object)this);
        }
        catch (NoSuchFieldException e) {
            this.getLog().warn((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.getLog().warn((Throwable)e);
        }
        return null;
    }
}

