package ch.sahits.game.event;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * Base class for the Events passed in the game.
 * All methods are quarded by the same lock to ensure thread savety.
 * @author andi
 *
 */
public class Event {

	private static ConcurrentLinkedQueue<IEventListener> listeners = new ConcurrentLinkedQueue<IEventListener>();
	private final static Object lock = new Object();
	
	public static void add(IEventListener listener){
		synchronized (lock) {
			if (!listeners.contains(listener)) {
				listeners.add(listener);
			}
		}
	}
	public static void remove(IEventListener listener){
		synchronized (lock) {
			listeners.remove(listener);
		}
	}
	public void notify(Object eventNotice){
		synchronized (lock) {
			for (IEventListener listener : listeners) {
				if (listener!=null){
					listener.gameUpdate(this, eventNotice);
				}
			}
		}
	}
}
