package ch.sahits.game.event.data;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * Periodical update event happens every 24h. The addresse and the target may be the same
 * instance or the addresse may be a holding instance which delegates to the target.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 23, 2014
 */
@RequiredArgsConstructor
public class PeriodicalDailyUpdate extends PeriodicalTimeUpdate {
    private final Object addresse;
    @Getter
    private final Object target;
    public boolean isAddresse(Object o) {
        return addresse.equals(o);
    }
}
