package ch.sahits.game.event.data;

import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

/**
 * Event object that is used on the tick after the day change.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Jan 25, 2014
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class ClockTickPostDayChange implements IClockTick, IEventMetaDataProvider {
    private String className;
    private String methodName;

    public ClockTickPostDayChange() {
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
