package ch.sahits.game.event.data;

import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

import java.time.LocalDateTime;

/**
 * Periodical update event happens every 24h.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 23, 2014
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class PeriodicalDailyUpdate extends PeriodicalTimeUpdate implements IEventMetaDataProvider {
    private String className;
    private String methodName;
    public PeriodicalDailyUpdate(LocalDateTime dateTime) {
        super(dateTime);
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
