package ch.sahits.game.event.data;

import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

import java.time.LocalDateTime;

/**
 * Update date for monthly updates, not necessarily on the date change.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Jan 26, 2014
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class PeriodicalTimeMonthEndUpdate extends PeriodicalTimeUpdate implements IEventMetaDataProvider {
    private String className;
    private String methodName;

    public PeriodicalTimeMonthEndUpdate(LocalDateTime dateTime) {
        super(dateTime);
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
