package ch.sahits.game.event.data;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

import java.time.LocalDateTime;

/**
 * Update date for end of year updates.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Jan 26, 2014
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class PeriodicalTimeYearEndUpdate extends PeriodicalTimeUpdate {
    private String className;
    private String methodName;
    public PeriodicalTimeYearEndUpdate(LocalDateTime dateTime) {
        super(dateTime);
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
