package ch.sahits.game.event;

import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

/**
 * Event for updating a view
 * @author andi
 *
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class ViewChangeEvent implements IEventMetaDataProvider {

	private final Class<?> addresse;
    private final Object eventNotice;
    private String className;
    private String methodName;

    public ViewChangeEvent(Class<?> addresse, Object eventNotice) {
        this.addresse = addresse;
        this.eventNotice = eventNotice;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
