package ch.sahits.game.event.data;

import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.Setter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Jan 26, 2014
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class ClockTickIntervalChange implements IEventMetaDataProvider {
    @Setter
    private int interval;
    private String className;
    private String methodName;

    public ClockTickIntervalChange() {
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
