package ch.sahits.game.event.data;

import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

/**
 * Event object for resuming the game.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jan 13, 2016
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class ResumeGame implements IEventMetaDataProvider {
    private String className;
    private String methodName;

    public ResumeGame() {
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
