/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.server;

import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class ServerLauncher {
    private static final Logger logger = Logger.getLogger(ServerLauncher.class);
    private static ApplicationContext baseServerContext = null;
    private static ApplicationContext serverContext = null;

    public static boolean isApplicationContextInitialized() {
        return serverContext != null;
    }

    public static void initializeApplicationContext(Class clientServerContextClass) {
        Preconditions.checkArgument((baseServerContext == null ? 1 : 0) != 0, (Object)"Application baseServerContext is already initialized");
        baseServerContext = new AnnotationConfigApplicationContext(new Class[]{clientServerContextClass});
        logger.info((Object)("Initialize baseServerContext (" + baseServerContext.hashCode() + ") with class " + clientServerContextClass.getName()));
        ((AbstractApplicationContext)baseServerContext).registerShutdownHook();
    }

    public static ApplicationContext getClientServerContext() {
        return baseServerContext;
    }
}

