/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.spring;

import ch.sahits.game.openpatrician.event.SubscriptionLoggingExceptionHandler;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.spring.ClientServerInterfaceCommonConfiguration;
import ch.sahits.game.openpatrician.spring.ModelConfiguration;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@Import(value={ClientServerInterfaceCommonConfiguration.class, ModelConfiguration.class})
public class ClientServerInterfaceStandaloneConfiguration {
    @Autowired
    @Qualifier(value="serverThreadPool")
    private ThreadPoolTaskExecutor serverThreadPool;
    @Autowired
    private SubscriptionLoggingExceptionHandler subscriptionExceptionHandler;

    @Bean
    public AsyncEventBus serverClientEventBus() {
        return new AsyncEventBus((Executor)this.serverThreadPool, (SubscriberExceptionHandler)this.subscriptionExceptionHandler);
    }

    @Bean
    public TimedUpdatableTaskList clientTimedTaskListener() {
        return new TimedUpdatableTaskList();
    }

    private static class AsyncEventBusWrapper
    extends AsyncEventBus {
        public AsyncEventBusWrapper(String identifier, Executor executor) {
            super(identifier, executor);
        }

        public AsyncEventBusWrapper(Executor executor, SubscriberExceptionHandler subscriberExceptionHandler) {
            super(executor, subscriberExceptionHandler);
        }

        public AsyncEventBusWrapper(Executor executor) {
            super(executor);
        }

        public void post(Object event) {
            System.out.println("Post event " + event.getClass().getName() + " on AsynchEventBus");
            super.post(event);
        }
    }
}

