/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.event;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SubscriptionLoggingExceptionHandler
implements SubscriberExceptionHandler {
    private final Logger logger;

    public SubscriptionLoggingExceptionHandler(String identifier) {
        this.logger = Logger.getLogger(SubscriptionLoggingExceptionHandler.class.getName() + "." + (String)Preconditions.checkNotNull((Object)identifier));
    }

    public void handleException(Throwable exception, SubscriberExceptionContext context) {
        this.logger.log(Level.SEVERE, "Could not dispatch event: " + context.getSubscriber() + " to " + context.getSubscriberMethod(), exception.getCause());
        exception.printStackTrace();
    }
}

