/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.server;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.spring.DependentAnnotationConfigApplicationContext;
import com.google.common.base.Preconditions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

@ClassCategory(value={EClassCategory.STARTUP})
public class ServerLauncher {
    private static final Logger logger = LogManager.getLogger(ServerLauncher.class);
    private static ApplicationContext baseServerContext = null;
    private static ApplicationContext serverContext = null;

    public static boolean isApplicationContextInitialized() {
        return serverContext != null;
    }

    public static void initializeApplicationContext(Class clientServerContextClass) {
        Preconditions.checkArgument((baseServerContext == null ? 1 : 0) != 0, (Object)"Application baseServerContext is already initialized");
        baseServerContext = new DependentAnnotationConfigApplicationContext(new Class[]{clientServerContextClass});
        logger.info("Initialize baseServerContext (" + baseServerContext.hashCode() + ") with class " + clientServerContextClass.getName());
        ((AbstractApplicationContext)baseServerContext).registerShutdownHook();
    }

    public static ApplicationContext getClientServerContext() {
        return baseServerContext;
    }
}

