/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.factory;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIStrategyProvider;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategyType;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class AIStrategyLoader {
    List<IAITradeStrategyType> getTradeStrategies() {
        ArrayList<IAITradeStrategyType> tradeStrategies = new ArrayList<IAITradeStrategyType>();
        ServiceLoader<IAIStrategyProvider> strategyProvider = ServiceLoader.load(IAIStrategyProvider.class, ClassLoader.getSystemClassLoader());
        for (IAIStrategyProvider provider : strategyProvider) {
            tradeStrategies.addAll(provider.getTradeStrategies());
        }
        return tradeStrategies;
    }

    List<IAIShipRepairStrategyType> getRepairStrategies() {
        ArrayList<IAIShipRepairStrategyType> repairStrategies = new ArrayList<IAIShipRepairStrategyType>();
        ServiceLoader<IAIStrategyProvider> strategyProvider = ServiceLoader.load(IAIStrategyProvider.class, ClassLoader.getSystemClassLoader());
        for (IAIStrategyProvider provider : strategyProvider) {
            repairStrategies.addAll(provider.getRepairStrategies());
        }
        return repairStrategies;
    }

    List<IAITakeLoanStrategyType> getTakeLoanStrategies() {
        ArrayList<IAITakeLoanStrategyType> takeLoanStrategies = new ArrayList<IAITakeLoanStrategyType>();
        ServiceLoader<IAIStrategyProvider> strategyProvider = ServiceLoader.load(IAIStrategyProvider.class, ClassLoader.getSystemClassLoader());
        for (IAIStrategyProvider provider : strategyProvider) {
            takeLoanStrategies.addAll(provider.getTakeLoanStrategies());
        }
        return takeLoanStrategies;
    }
}

