/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.factory;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.ICog;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.ICrayer;
import ch.sahits.game.openpatrician.model.ship.IHolk;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

@LazySingleton
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ShipFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private Date date;
    @Autowired
    private IMap map;
    @Autowired
    private ApplicationContext context;
    @Value(value="${ship.min.capacity.snaikka}")
    private int snaikkaStartCapacity = 150;
    @Value(value="${ship.max.capacity.snaikka}")
    private int snaikkaMaxCapacity = 250;
    @Value(value="${ship.min.capacity.crayer}")
    private int crayerStartCapacity = 280;
    @Value(value="${ship.max.capacity.crayer}")
    private int crayerMaxCapacity = 350;
    @Value(value="${ship.min.capacity.cog}")
    private int cogStartCapacity = 450;
    @Value(value="${ship.max.capacity.cog}")
    private int cogMaxCapacity = 580;
    @Value(value="${ship.min.capacity.holk}")
    private int holkStartCapacity = 550;
    @Value(value="${ship.max.capacity.holk}")
    private int holkMaxCapacity = 700;

    private Properties getHolkDefaultProperties() throws IOException {
        ClassPathResource resource = new ClassPathResource("/ship_holk.properties");
        return PropertiesLoaderUtils.loadProperties((Resource)resource);
    }

    private Properties getCogDefaultProperties() throws IOException {
        ClassPathResource resource = new ClassPathResource("/ship_cog.properties");
        return PropertiesLoaderUtils.loadProperties((Resource)resource);
    }

    private Properties getCrayerDefaultProperties() throws IOException {
        ClassPathResource resource = new ClassPathResource("/ship_crayer.properties");
        return PropertiesLoaderUtils.loadProperties((Resource)resource);
    }

    private Properties getSnikkaDefaultProperties() throws IOException {
        ClassPathResource resource = new ClassPathResource("/ship_schnikka.properties");
        return PropertiesLoaderUtils.loadProperties((Resource)resource);
    }

    public ICrayer createCrayer(String name, int value) {
        Properties crayer = null;
        try {
            crayer = this.getCrayerDefaultProperties();
            crayer.setProperty("size", String.valueOf(value));
        }
        catch (IOException e) {
            this.logger.error("Failed to initialize ship properties", (Throwable)e);
        }
        ICrayer ship = (ICrayer)this.context.getBean("crayer", new Object[]{name, crayer, System.nanoTime()});
        return ship;
    }

    public ICrayer createCrayer(String name, EShipUpgrade upgradeLevel, int value) {
        Properties crayer = null;
        try {
            crayer = this.getCrayerDefaultProperties();
            crayer.setProperty("size", String.valueOf(value));
        }
        catch (IOException e) {
            this.logger.error("Failed to initialize ship properties", (Throwable)e);
        }
        ICrayer ship = (ICrayer)this.context.getBean("crayer", new Object[]{upgradeLevel, name, crayer, System.nanoTime()});
        return ship;
    }

    public ISnaikka createSnaikka(String name, int value) {
        Properties snikka = null;
        try {
            snikka = this.getSnikkaDefaultProperties();
            snikka.setProperty("size", String.valueOf(value));
        }
        catch (IOException e) {
            this.logger.error("Failed to initialize ship properties", (Throwable)e);
        }
        ISnaikka snaikka = (ISnaikka)this.context.getBean("snaikka", new Object[]{name, snikka, System.nanoTime()});
        return snaikka;
    }

    public ISnaikka createSnaikka(String name, EShipUpgrade upgradeLevel, int value) {
        Properties snikka = null;
        try {
            snikka = this.getSnikkaDefaultProperties();
            snikka.setProperty("size", String.valueOf(value));
        }
        catch (IOException e) {
            this.logger.error("Failed to initialize ship properties", (Throwable)e);
        }
        ISnaikka snaikka = (ISnaikka)this.context.getBean("snaikka", new Object[]{upgradeLevel, name, snikka, System.nanoTime()});
        return snaikka;
    }

    public ICog createCog(String name, int value) {
        Properties cog = null;
        try {
            cog = this.getCogDefaultProperties();
            cog.setProperty("size", String.valueOf(value));
        }
        catch (IOException e) {
            this.logger.error("Failed to initialize ship properties", (Throwable)e);
        }
        ICog ship = (ICog)this.context.getBean("cog", new Object[]{name, cog, System.nanoTime()});
        return ship;
    }

    public ICog createCog(String name, EShipUpgrade upgradeLevel, int value) {
        Properties cog = null;
        try {
            cog = this.getCogDefaultProperties();
            cog.setProperty("size", String.valueOf(value));
        }
        catch (IOException e) {
            this.logger.error("Failed to initialize ship properties", (Throwable)e);
        }
        ICog ship = (ICog)this.context.getBean("cog", new Object[]{upgradeLevel, name, cog, System.nanoTime()});
        return ship;
    }

    public IHolk createHolk(String name, int value) {
        Properties holk = null;
        try {
            holk = this.getHolkDefaultProperties();
            holk.setProperty("size", String.valueOf(value));
        }
        catch (IOException e) {
            this.logger.error("Failed to initialize ship properties", (Throwable)e);
        }
        IHolk ship = (IHolk)this.context.getBean("holk", new Object[]{name, holk, System.nanoTime()});
        return ship;
    }

    public IHolk createHolk(String name, EShipUpgrade upgradeLevel, int value) {
        Properties holk = null;
        try {
            holk = this.getHolkDefaultProperties();
            holk.setProperty("size", String.valueOf(value));
        }
        catch (IOException e) {
            this.logger.error("Failed to initialize ship properties", (Throwable)e);
        }
        IHolk ship = (IHolk)this.context.getBean("holk", new Object[]{upgradeLevel, name, holk, System.nanoTime()});
        return ship;
    }

    public int calculateInitialCapacity(EShipType type, double x) {
        double startYearPart = Math.max((this.date.getCurrentDate().getYear() - 1430) / 100, 0);
        int mapWidth = (int)this.map.getDimension().getWidth();
        double eastFactor = x / (double)mapWidth / 0.5;
        double factor = Math.max(startYearPart - eastFactor, 0.0);
        switch (type) {
            case SNAIKKA: {
                int sizeDiff = this.snaikkaMaxCapacity - this.snaikkaStartCapacity;
                return (int)((double)this.snaikkaStartCapacity + Math.rint(factor * (double)sizeDiff));
            }
            case CRAYER: {
                int sizeDiff = this.crayerMaxCapacity - this.crayerStartCapacity;
                return (int)((double)this.crayerStartCapacity + Math.rint(factor * (double)sizeDiff));
            }
            case COG: {
                int sizeDiff = this.cogMaxCapacity - this.cogStartCapacity;
                return (int)((double)this.cogStartCapacity + Math.rint(factor * (double)sizeDiff));
            }
            case HOLK: {
                int sizeDiff = this.holkMaxCapacity - this.holkStartCapacity;
                return (int)((double)this.holkStartCapacity + Math.rint(factor * (double)sizeDiff));
            }
        }
        return 0;
    }

    public int getUpgradeAmount(EShipType type, EWare ware) {
        int typeAddition = 0;
        switch (type) {
            case SNAIKKA: {
                typeAddition = 0;
                break;
            }
            case CRAYER: {
                typeAddition = 1;
                break;
            }
            case COG: {
                typeAddition = 2;
                break;
            }
            case HOLK: {
                typeAddition = 3;
            }
        }
        switch (ware) {
            case WOOD: {
                return 2 + typeAddition;
            }
            case PITCH: 
            case IRON: {
                return 1 + typeAddition;
            }
        }
        return 0;
    }

    public int getConstructionAmount(EShipType type, EWare ware) {
        switch (type) {
            case SNAIKKA: {
                switch (ware) {
                    case WOOD: {
                        return 11;
                    }
                    case CLOTH: {
                        return 3;
                    }
                    case IRON: {
                        return 3;
                    }
                    case HEMP: {
                        return 3;
                    }
                    case PITCH: {
                        return 20;
                    }
                }
                throw new IllegalArgumentException("Not defined: " + type + " " + ware);
            }
            case CRAYER: {
                switch (ware) {
                    case WOOD: {
                        return 16;
                    }
                    case CLOTH: {
                        return 5;
                    }
                    case IRON: {
                        return 5;
                    }
                    case HEMP: {
                        return 5;
                    }
                    case PITCH: {
                        return 30;
                    }
                }
                throw new IllegalArgumentException("Not defined: " + type + " " + ware);
            }
            case COG: {
                switch (ware) {
                    case WOOD: {
                        return 22;
                    }
                    case CLOTH: {
                        return 3;
                    }
                    case IRON: {
                        return 4;
                    }
                    case HEMP: {
                        return 4;
                    }
                    case PITCH: {
                        return 40;
                    }
                }
                throw new IllegalArgumentException("Not defined: " + type + " " + ware);
            }
            case HOLK: {
                switch (ware) {
                    case WOOD: {
                        return 36;
                    }
                    case CLOTH: {
                        return 10;
                    }
                    case IRON: {
                        return 10;
                    }
                    case HEMP: {
                        return 8;
                    }
                    case PITCH: {
                        return 50;
                    }
                }
                throw new IllegalArgumentException("Not defined: " + type + " " + ware);
            }
        }
        return 0;
    }

    public int getMinimalSailors(EShipType type) {
        switch (type) {
            case SNAIKKA: {
                return 5;
            }
            case CRAYER: {
                return 8;
            }
            case COG: {
                return 10;
            }
            case HOLK: {
                return 15;
            }
        }
        return 0;
    }

    public int getShipSpeed(EShipType type) {
        switch (type) {
            case SNAIKKA: {
                return 5;
            }
            case CRAYER: {
                return 6;
            }
            case COG: {
                return 4;
            }
            case HOLK: {
                return 5;
            }
        }
        return 0;
    }

    public IConvoy getConvoy(IShip ship, boolean isPublicConvoy) {
        return (IConvoy)this.context.getBean("convoy", new Object[]{ship, isPublicConvoy});
    }

    public IShipGroup getShipGroup(IShip leadShip) {
        return (IShipGroup)this.context.getBean("shipGroup", new Object[]{leadShip});
    }
}

