/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.CityProductionStorage;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.city.ProductionStorage;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.product.ProductionChain;
import ch.sahits.game.openpatrician.util.MapInitializedBean;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=MapInitializedBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CityProductionAndConsumptionService {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Value(value="${city.population.amount.workshop}")
    private int populationAmountPerWorkshop = 500;
    @Value(value="${city.production.inefficient.factor}")
    private double inefficiencyFactor = 0.5;
    @Autowired
    private Random rnd;
    @Autowired
    private PopulationConsume consume;
    @Autowired
    private CityProductionStorage cityProductionStorage;
    @Autowired
    private ProductionChain productionChain;
    @Autowired
    private IMap map;

    @PostConstruct
    private void init() {
        for (ICity city : this.map.getCities()) {
            this.buyWaresForNextWeek(city);
        }
    }

    public void produceWares(CityState cityState) {
        this.makeProducedWaresAvailable(cityState.getCity());
        this.buyWaresForNextWeek(cityState.getCity());
    }

    public void consumeWares(CityState cityState) {
        EWare[] wares = EWare.values();
        EPopulationClass[] popClasses = EPopulationClass.values();
        ICity city = cityState.getCity();
        for (EWare ware : wares) {
            double amount = cityState.getConsumedAmount(ware);
            for (EPopulationClass popClass : popClasses) {
                amount += this.consume.getNeed((IWare)ware, popClass, city.getPopulation(popClass)) / 14.0;
            }
            cityState.replaceConsumedAmount((IWare)ware, amount);
        }
        for (Map.Entry entry : cityState.consumedEntries()) {
            int whole;
            if (!((Double)entry.getValue() > 0.0) || (whole = this.convertToWholeNumber((Double)entry.getValue())) < 1) continue;
            cityState.replaceConsumedAmount((IWare)entry.getKey(), (Double)entry.getValue() - (double)whole);
            city.move((IWare)entry.getKey(), -whole, null);
        }
    }

    private int convertToWholeNumber(double value) {
        if (value >= 1.0) {
            return (int)Math.rint(Math.floor(value));
        }
        if (this.rnd.nextDouble() > value) {
            return 1;
        }
        return 0;
    }

    @VisibleForTesting
    void buyWaresForNextWeek(ICity city) {
        Map<IWare, Double> requireWares = this.calculateConsumptionByProductionChain(city);
        ProductionStorage storage = this.cityProductionStorage.getStorage(city);
        for (IWare requiredWare : requireWares.keySet()) {
            double requiredAmount = requireWares.get(requiredWare) - storage.getStored(requiredWare);
            int amountToBuy = (int)Math.ceil(requiredAmount);
            int boughtAmount = -city.move(requiredWare, -amountToBuy, null);
            storage.transfer(requiredWare, (double)boughtAmount);
        }
    }

    public Map<IWare, Double> calculateConsumptionByProductionChain(ICity city) {
        List<IWare> wares = this.collectProducableWares(city);
        HashMap<IWare, Double> requireWares = new HashMap<IWare, Double>();
        for (IWare ware : wares) {
            double adjustmentFactor = 1.0;
            if (!this.isEffectiveProduction(city, ware)) {
                adjustmentFactor = this.inefficiencyFactor;
            }
            int population = city.getPopulationBinding().get();
            int amountWorkshops = population / this.populationAmountPerWorkshop + 1;
            List required = this.productionChain.getRequiredWares(ware);
            for (IWare requiredWare : required) {
                double requiredAmount = this.productionChain.getRequiredAmount(ware, requiredWare) * (double)amountWorkshops * adjustmentFactor;
                if (requireWares.containsKey(requiredWare)) {
                    double update = (Double)requireWares.get(requiredWare) + requiredAmount;
                    requireWares.put(requiredWare, update);
                    continue;
                }
                requireWares.put(requiredWare, requiredAmount);
            }
        }
        return requireWares;
    }

    public int getProductionOutputCurrentWeek(IWare ware, ICity city) {
        return (int)Math.floor(this.getExactOutputCurrentWeek(ware, city));
    }

    public int guessProductionInCity(IWare ware, ICity city) {
        if (!this.isProducable(city, ware)) {
            return 0;
        }
        double adjustmentFactor = 1.0;
        if (!this.isEffectiveProduction(city, ware)) {
            adjustmentFactor = this.inefficiencyFactor;
        }
        double theoreticalProducableAmount = this.productionChain.getProduction(ware) * adjustmentFactor;
        return (int)Math.floor(theoreticalProducableAmount);
    }

    private double getExactOutputCurrentWeek(IWare ware, ICity city) {
        if (!this.isProducable(city, ware)) {
            return 0.0;
        }
        double adjustmentFactor = 1.0;
        if (!this.isEffectiveProduction(city, ware)) {
            adjustmentFactor = this.inefficiencyFactor;
        }
        int population = city.getPopulationBinding().get();
        int amountWorkshops = population / this.populationAmountPerWorkshop + 1;
        double theoreticalProducableAmount = this.productionChain.getProduction(ware) * (double)amountWorkshops * adjustmentFactor;
        List requiredWares = this.productionChain.getRequiredWares(ware);
        if (requiredWares.isEmpty()) {
            return theoreticalProducableAmount;
        }
        ProductionStorage storage = this.cityProductionStorage.getStorage(city);
        double minProducableAmount = theoreticalProducableAmount;
        for (IWare requiredWare : requiredWares) {
            double requiredAmount = this.productionChain.getRequiredAmount(ware, requiredWare) * (double)amountWorkshops * adjustmentFactor;
            double storedAmount = storage.getStored(requiredWare);
            if (storedAmount >= requiredAmount) {
                minProducableAmount = Math.min(theoreticalProducableAmount, minProducableAmount);
                continue;
            }
            double factor = storedAmount / requiredAmount;
            minProducableAmount = Math.min(theoreticalProducableAmount * factor, minProducableAmount);
        }
        return minProducableAmount;
    }

    public int getTheoreticalProducableAmount(IWare ware, ICity city) {
        if (!this.isProducable(city, ware)) {
            return 0;
        }
        double adjustmentFactor = 1.0;
        if (!this.isEffectiveProduction(city, ware)) {
            adjustmentFactor = this.inefficiencyFactor;
        }
        int population = city.getPopulationBinding().get();
        int amountWorkshops = population / this.populationAmountPerWorkshop + 1;
        return (int)Math.rint(this.productionChain.getProduction(ware) * (double)amountWorkshops * adjustmentFactor);
    }

    private boolean isEffectiveProduction(ICity city, IWare ware) {
        IWare[] wares;
        for (IWare iWare : wares = city.getEffectiveProduction()) {
            if (!ware.equals(iWare)) continue;
            return true;
        }
        return false;
    }

    private boolean isProducable(ICity city, IWare ware) {
        List<IWare> wares = this.collectProducableWares(city);
        for (IWare iWare : wares) {
            if (!ware.equals(iWare)) continue;
            return true;
        }
        return false;
    }

    private List<IWare> collectProducableWares(ICity city) {
        ArrayList<IWare> wares = new ArrayList<IWare>();
        wares.addAll(Arrays.asList(city.getEffectiveProduction()));
        wares.addAll(Arrays.asList(city.getIneffectiveProduction()));
        return wares;
    }

    @VisibleForTesting
    void makeProducedWaresAvailable(ICity city) {
        List<IWare> wares = this.collectProducableWares(city);
        for (IWare ware : wares) {
            double producedAmount = this.getExactOutputCurrentWeek(ware, city);
            int makeAvailableAmount = (int)Math.floor(producedAmount);
            double remainingAmount = producedAmount - (double)makeAvailableAmount;
            ProductionStorage storage = this.cityProductionStorage.getStorage(city);
            storage.transfer(ware, remainingAmount);
            if (storage.getStored(ware) > 1.0) {
                int fromStorage = (int)Math.floor(storage.getStored(ware));
                storage.transfer(ware, (double)(-fromStorage));
                makeAvailableAmount += fromStorage;
            }
            city.move(ware, makeAvailableAmount, null);
            List requiredWares = this.productionChain.getRequiredWares(ware);
            double adjustmentFactor = 1.0;
            if (!this.isEffectiveProduction(city, ware)) {
                adjustmentFactor = this.inefficiencyFactor;
            }
            int population = city.getPopulationBinding().get();
            int amountWorkshops = population / this.populationAmountPerWorkshop + 1;
            for (IWare requiredWare : requiredWares) {
                double requiredAmount = this.productionChain.getRequiredAmount(ware, requiredWare) * (double)amountWorkshops * adjustmentFactor;
                double storedAmount = storage.getStored(requiredWare);
                double removeAmount = Math.min(requiredAmount, storedAmount);
                storage.transfer(requiredWare, -removeAmount);
            }
        }
    }
}

