/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.PeopleFactory;
import ch.sahits.game.openpatrician.collections.SortedMapRandomizedSameElements;
import ch.sahits.game.openpatrician.model.AmountableProvider;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.CityHallList;
import ch.sahits.game.openpatrician.model.city.cityhall.ECityViolationPunishment;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHallNotice;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CityHallNotice;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.event.FoundingCityBecomesAccessible;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.map.ITradeRoute;
import ch.sahits.game.openpatrician.model.map.ITradeRouteStop;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javafx.beans.binding.IntegerBinding;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class MapService {
    @Autowired
    private IMap map;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private PeopleFactory peopleFactory;
    @Autowired
    private CityHallList cityHalls;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private ComputablePriceV2 computablePrice;
    @Autowired
    private AmountableProvider amountableProvider;
    private final Range<Double> range = Range.openClosed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0));

    public Optional<ICity> findNearbyCity(ICity startCity, double radiusFactor, int max, List<ICity> exclude) {
        List cities = this.map.getCities();
        Preconditions.checkArgument((boolean)this.range.contains((Comparable)Double.valueOf(radiusFactor)), (Object)"Range factor must be in (0,1]");
        double radius = (double)max * radiusFactor;
        LinkedList copy = new LinkedList(cities);
        Collections.shuffle(copy);
        Point2D p1 = startCity.getCoordinates();
        for (ICity city : copy) {
            Point2D p2;
            double dist;
            if (exclude.contains(city) || city.equals(startCity) || !((dist = this.calculateDistance(p1, p2 = city.getCoordinates())) <= radius)) continue;
            return Optional.of(city);
        }
        return Optional.empty();
    }

    public ICity findNearbyCityRepeated(ICity startCity, double radiusFactor, int max, List<ICity> exclude) {
        Preconditions.checkArgument((boolean)this.checkCities(startCity, exclude), (Object)"No city is choosable");
        Optional<ICity> result = this.findNearbyCity(startCity, radiusFactor, max, exclude);
        while (!result.isPresent()) {
            result = this.findNearbyCity(startCity, radiusFactor *= 1.01, max, exclude);
        }
        return result.get();
    }

    private boolean checkCities(ICity startCity, List<ICity> exclude) {
        List cities = this.map.getCities();
        for (ICity city : cities) {
            if (city.equals(startCity) || exclude.contains(city)) continue;
            return true;
        }
        return false;
    }

    public ICity findNearestCity(Point2D p) {
        List cities = this.map.getCities();
        ICity nearest = (ICity)cities.get(0);
        double dist = this.calculateDistance(p, nearest.getCoordinates());
        for (int i = 1; i < cities.size(); ++i) {
            ICity city = (ICity)cities.get(i);
            double d = this.calculateDistance(p, city.getCoordinates());
            if (!(d < dist) || !(d > 0.0)) continue;
            dist = d;
            nearest = city;
        }
        return nearest;
    }

    public ICity findRandomCity(ICity excludedCity) {
        return this.findRandomCity(Arrays.asList(excludedCity));
    }

    private ICity findRandomCity(List<ICity> excludedCity) {
        ArrayList cities = Lists.newArrayList((Iterable)this.map.getCities());
        cities.removeAll(excludedCity);
        int index = this.rnd.nextInt(cities.size());
        return (ICity)cities.get(index);
    }

    private double calculateDistance(Point2D p1, Point2D p2) {
        double diffX = p1.getX() - p2.getX();
        double diffY = p1.getY() - p2.getY();
        return Math.sqrt(diffX * diffX + diffY * diffY);
    }

    public List<ICity> findRandomCities(ICity exclude, int numberOfCities) {
        int max = Math.min(this.map.getNumberCities() - 1, numberOfCities);
        ArrayList<ICity> selected = new ArrayList<ICity>();
        selected.add(exclude);
        while (selected.size() < max + 1) {
            ICity next = this.findRandomCity(selected);
            selected.add(next);
        }
        selected.remove(exclude);
        return selected;
    }

    public int getMaxNumberOfGuards(int population) {
        if (population <= 1000) {
            return 5;
        }
        double b = 3.8;
        if (population <= 20000) {
            double v = (double)population / (2.0 * (30.0 + b));
            return (int)Math.rint((v + b) / 10.0);
        }
        double v = (double)population / (2.65 * (30.0 + b));
        return (int)Math.rint((v + b) / 10.0);
    }

    public ObservableList<ICityHallNotice> createNotices(ICity targetCity) {
        ArrayList<CityHallNotice> notices = new ArrayList<CityHallNotice>();
        List<ICity> cities = this.findRandomCities(targetCity, 3);
        for (ICity iCity : cities) {
            CityState state = iCity.getCityState();
            Optional ware = state.findMostNeededWare();
            if (!ware.isPresent()) continue;
            int price = this.computablePrice.sellPrice((ITradable)ware.get(), iCity.getWare((IWare)ware.get()).amountProperty(), new IntegerBinding(){

                protected int computeValue() {
                    return 5;
                }
            });
            AmountablePrice amountable = this.amountableProvider.createWareAmountable();
            int amount = ((IWare)ware.get()).isBarrelSizedWare() ? this.rnd.nextInt(300) - 20 : this.rnd.nextInt(30) - 2;
            int deliverInDays = this.rnd.nextInt(20) + 1;
            DateTime dueDate = this.date.getCurrentDate().plusDays(deliverInDays);
            amountable.add(amount, (int)((double)price * 1.15));
            IContractBroker broker = this.peopleFactory.createNewContractBroker((AmountablePrice<IWare>)amountable, (IWare)ware.get());
            CityHallNotice notice = CityHallNotice.builder().contact(broker).destination(iCity).requiredWare((IWare)ware.get()).wareAndAmount(amountable).dueDate(dueDate).build();
            notices.add(notice);
        }
        return FXCollections.observableArrayList(notices);
    }

    public int getFine(ECityViolationPunishment punishment, ITreasury otherTreasury) {
        switch (punishment) {
            case SMALL_FINE: {
                return (int)(otherTreasury.getCash() / 100L);
            }
            case MEDIUM_FINE: {
                return (int)(otherTreasury.getCash() / 10L);
            }
            case LARGE_FINE: {
                return (int)((double)otherTreasury.getCash() * 0.9);
            }
            case NONE: {
                return 0;
            }
        }
        throw new IllegalStateException("The punishment " + punishment + " cannot be handled with a fine");
    }

    public SortedMapRandomizedSameElements<Integer, ICitizen> getCandidateMap(List<ICitizen> candidates, ICity city) {
        ArrayList<ICitizen> citizens = new ArrayList<ICitizen>();
        HashMap initialMap = new HashMap();
        initialMap.put(0, citizens);
        for (ICitizen citizen : candidates) {
            if (citizen instanceof IPlayer) {
                List<ICitizen> list;
                IReputation reputation = city.getReputation((IPlayer)citizen);
                int rep = reputation.getPopularity();
                if (initialMap.containsKey(rep)) {
                    list = (List)initialMap.get(rep);
                    list.add(citizen);
                    initialMap.put(rep, list);
                    continue;
                }
                list = new ArrayList<ICitizen>();
                ((ArrayList)list).add(citizen);
                initialMap.put(rep, list);
                continue;
            }
            citizens.add(citizen);
        }
        return new SortedMapRandomizedSameElements(initialMap);
    }

    public boolean isMayor(IPlayer player, ICity city) {
        for (ICityHall cityHall : this.cityHalls) {
            if (!city.equals(cityHall.getCity())) continue;
            return player.equals(cityHall.getMayor());
        }
        return false;
    }

    public void buildSettlement(ICity city, IPlayer player) {
        this.map.getTownsInFounding().put((Object)player, (Object)city);
    }

    public void settlementBecomesTown(ICity city) {
        this.map.add(city);
        Multimap townsInFounding = this.map.getTownsInFounding();
        Iterator iterator = townsInFounding.keySet().iterator();
        while (iterator.hasNext()) {
            IPlayer player = (IPlayer)iterator.next();
            if (!townsInFounding.get((Object)player).equals(city)) continue;
            Collection cities = townsInFounding.get((Object)player);
            cities.remove(city);
            if (!cities.isEmpty()) break;
            iterator.remove();
            break;
        }
        this.clientServerEventBus.post((Object)new FoundingCityBecomesAccessible(city));
    }

    public double convertToDistenceInKm(double nbPixels) {
        double nbPixelsPerKilometer = this.map.getNumberOfPixelPerKilometer();
        double distanceInKm = nbPixels / nbPixelsPerKilometer;
        return distanceInKm;
    }

    public List<ICity> getCitiesOrderedByDistance(ICity city) {
        CityDistanceComparator comparator = new CityDistanceComparator(city);
        ArrayList<ICity> cities = new ArrayList<ICity>(this.map.getCities());
        cities.remove(city);
        Collections.sort(cities, comparator);
        return cities;
    }

    public List<ITradeRoute> findTradeRoutesFirstStop(ICity city) {
        ArrayList<ITradeRoute> routes = new ArrayList<ITradeRoute>();
        for (ITradeRoute route : this.map.getTradeRoutes()) {
            ITradeRouteStop stop = (ITradeRouteStop)route.getTradeStops().iterator().next();
            if (!stop.getTradeStop().equals(city)) continue;
            routes.add(route);
        }
        return routes;
    }

    public List<ITradeRoute> findTradeRoutesSecondStop(ICity city) {
        ArrayList<ITradeRoute> routes = new ArrayList<ITradeRoute>();
        for (ITradeRoute route : this.map.getTradeRoutes()) {
            ArrayList stops = new ArrayList(route.getTradeStops());
            ICity stopCity = ((ITradeRouteStop)stops.get(1)).getTradeStop();
            if (!stopCity.equals(city)) continue;
            routes.add(route);
        }
        return routes;
    }

    public boolean produces(ICity city, IWare ware) {
        if (Arrays.asList(city.getEffectiveProduction()).contains(ware)) {
            return true;
        }
        return Arrays.asList(city.getIneffectiveProduction()).contains(ware);
    }

    public boolean producesEfficiently(ICity city, IWare ware) {
        return Arrays.asList(city.getEffectiveProduction()).contains(ware);
    }

    public ICity getAldermanCity() {
        ICity assemblyPoint = null;
        for (ICityHall cityHall : this.cityHalls) {
            if (!cityHall.getAldermanOffice().isPresent()) continue;
            assemblyPoint = cityHall.getCity();
            break;
        }
        return assemblyPoint;
    }

    private static class CityDistanceComparator
    implements Comparator<ICity> {
        private final ICity originCity;

        public CityDistanceComparator(ICity city) {
            this.originCity = city;
        }

        @Override
        public int compare(ICity o1, ICity o2) {
            Point2D origin = this.originCity.getCoordinates();
            Point2D coord1 = o1.getCoordinates();
            Point2D coord2 = o2.getCoordinates();
            double dist1 = origin.distance(coord1);
            double dist2 = origin.distance(coord2);
            return (int)Math.rint(dist1 - dist2);
        }
    }
}

