/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.OptionalType;
import ch.sahits.game.openpatrician.dialog.IDialogState;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import java.util.Optional;
import org.joda.time.DateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class FireState
implements IDialogState {
    private DateTime date;
    private String location;
    private int destroyedBuildings;
    private int deathtoll;
    @OptionalType(value=ISpouseData.class)
    private Optional<ISpouseData> killedSpouse;

    public String getDialogBeanName() {
        return "fireDialog";
    }

    FireState(DateTime date, String location, int destroyedBuildings, int deathtoll, Optional<ISpouseData> killedSpouse) {
        this.date = date;
        this.location = location;
        this.destroyedBuildings = destroyedBuildings;
        this.deathtoll = deathtoll;
        this.killedSpouse = killedSpouse;
    }

    public static FireStateBuilder builder() {
        return new FireStateBuilder();
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getLocation() {
        return this.location;
    }

    public int getDestroyedBuildings() {
        return this.destroyedBuildings;
    }

    public int getDeathtoll() {
        return this.deathtoll;
    }

    public Optional<ISpouseData> getKilledSpouse() {
        return this.killedSpouse;
    }

    public static class FireStateBuilder {
        private DateTime date;
        private String location;
        private int destroyedBuildings;
        private int deathtoll;
        private Optional<ISpouseData> killedSpouse;

        FireStateBuilder() {
        }

        public FireStateBuilder date(DateTime date) {
            this.date = date;
            return this;
        }

        public FireStateBuilder location(String location) {
            this.location = location;
            return this;
        }

        public FireStateBuilder destroyedBuildings(int destroyedBuildings) {
            this.destroyedBuildings = destroyedBuildings;
            return this;
        }

        public FireStateBuilder deathtoll(int deathtoll) {
            this.deathtoll = deathtoll;
            return this;
        }

        public FireStateBuilder killedSpouse(Optional<ISpouseData> killedSpouse) {
            this.killedSpouse = killedSpouse;
            return this;
        }

        public FireState build() {
            return new FireState(this.date, this.location, this.destroyedBuildings, this.deathtoll, this.killedSpouse);
        }

        public String toString() {
            return "FireState.FireStateBuilder(date=" + this.date + ", location=" + this.location + ", destroyedBuildings=" + this.destroyedBuildings + ", deathtoll=" + this.deathtoll + ", killedSpouse=" + this.killedSpouse + ")";
        }
    }
}

