/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.dialog.IDialogState;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import org.joda.time.DateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class MarriageAnnouncementState
implements IDialogState {
    private DateTime date;
    private ISpouseData spouse;
    private DateTime weddingDate;
    private IPlayer player;

    public String getDialogBeanName() {
        return "marriageAnnouncementDialog";
    }

    MarriageAnnouncementState(DateTime date, ISpouseData spouse, DateTime weddingDate, IPlayer player) {
        this.date = date;
        this.spouse = spouse;
        this.weddingDate = weddingDate;
        this.player = player;
    }

    public static MarriageAnnouncementStateBuilder builder() {
        return new MarriageAnnouncementStateBuilder();
    }

    public DateTime getDate() {
        return this.date;
    }

    public ISpouseData getSpouse() {
        return this.spouse;
    }

    public DateTime getWeddingDate() {
        return this.weddingDate;
    }

    public IPlayer getPlayer() {
        return this.player;
    }

    public static class MarriageAnnouncementStateBuilder {
        private DateTime date;
        private ISpouseData spouse;
        private DateTime weddingDate;
        private IPlayer player;

        MarriageAnnouncementStateBuilder() {
        }

        public MarriageAnnouncementStateBuilder date(DateTime date) {
            this.date = date;
            return this;
        }

        public MarriageAnnouncementStateBuilder spouse(ISpouseData spouse) {
            this.spouse = spouse;
            return this;
        }

        public MarriageAnnouncementStateBuilder weddingDate(DateTime weddingDate) {
            this.weddingDate = weddingDate;
            return this;
        }

        public MarriageAnnouncementStateBuilder player(IPlayer player) {
            this.player = player;
            return this;
        }

        public MarriageAnnouncementState build() {
            return new MarriageAnnouncementState(this.date, this.spouse, this.weddingDate, this.player);
        }

        public String toString() {
            return "MarriageAnnouncementState.MarriageAnnouncementStateBuilder(date=" + this.date + ", spouse=" + this.spouse + ", weddingDate=" + this.weddingDate + ", player=" + this.player + ")";
        }
    }
}

