/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.OptionalType;
import ch.sahits.game.openpatrician.dialog.IDialogState;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import java.util.Optional;
import org.joda.time.DateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class PlagueState
implements IDialogState {
    private DateTime date;
    private String location;
    private DateTime since;
    private int deathtoll;
    @OptionalType(value=ISpouseData.class)
    private Optional<ISpouseData> killedSpouse;

    public String getDialogBeanName() {
        return "plagueDialog";
    }

    PlagueState(DateTime date, String location, DateTime since, int deathtoll, Optional<ISpouseData> killedSpouse) {
        this.date = date;
        this.location = location;
        this.since = since;
        this.deathtoll = deathtoll;
        this.killedSpouse = killedSpouse;
    }

    public static PlagueStateBuilder builder() {
        return new PlagueStateBuilder();
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getLocation() {
        return this.location;
    }

    public DateTime getSince() {
        return this.since;
    }

    public int getDeathtoll() {
        return this.deathtoll;
    }

    public Optional<ISpouseData> getKilledSpouse() {
        return this.killedSpouse;
    }

    public static class PlagueStateBuilder {
        private DateTime date;
        private String location;
        private DateTime since;
        private int deathtoll;
        private Optional<ISpouseData> killedSpouse;

        PlagueStateBuilder() {
        }

        public PlagueStateBuilder date(DateTime date) {
            this.date = date;
            return this;
        }

        public PlagueStateBuilder location(String location) {
            this.location = location;
            return this;
        }

        public PlagueStateBuilder since(DateTime since) {
            this.since = since;
            return this;
        }

        public PlagueStateBuilder deathtoll(int deathtoll) {
            this.deathtoll = deathtoll;
            return this;
        }

        public PlagueStateBuilder killedSpouse(Optional<ISpouseData> killedSpouse) {
            this.killedSpouse = killedSpouse;
            return this;
        }

        public PlagueState build() {
            return new PlagueState(this.date, this.location, this.since, this.deathtoll, this.killedSpouse);
        }

        public String toString() {
            return "PlagueState.PlagueStateBuilder(date=" + this.date + ", location=" + this.location + ", since=" + this.since + ", deathtoll=" + this.deathtoll + ", killedSpouse=" + this.killedSpouse + ")";
        }
    }
}

