/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.factory;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIConstructionSelectionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIStrategyProvider;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategyType;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class AIStrategyLoader {
    public List<IAITradeStrategyType> getTradeStrategies() {
        ArrayList<IAITradeStrategyType> tradeStrategies = new ArrayList<IAITradeStrategyType>();
        ServiceLoader<IAIStrategyProvider> strategyProvider = ServiceLoader.load(IAIStrategyProvider.class, ClassLoader.getSystemClassLoader());
        for (IAIStrategyProvider provider : strategyProvider) {
            tradeStrategies.addAll(provider.getTradeStrategies());
        }
        return tradeStrategies;
    }

    public List<IAIShipRepairStrategyType> getRepairStrategies() {
        ArrayList<IAIShipRepairStrategyType> repairStrategies = new ArrayList<IAIShipRepairStrategyType>();
        ServiceLoader<IAIStrategyProvider> strategyProvider = ServiceLoader.load(IAIStrategyProvider.class, ClassLoader.getSystemClassLoader());
        for (IAIStrategyProvider provider : strategyProvider) {
            repairStrategies.addAll(provider.getRepairStrategies());
        }
        return repairStrategies;
    }

    public List<IAITakeLoanStrategyType> getTakeLoanStrategies() {
        ArrayList<IAITakeLoanStrategyType> takeLoanStrategies = new ArrayList<IAITakeLoanStrategyType>();
        ServiceLoader<IAIStrategyProvider> strategyProvider = ServiceLoader.load(IAIStrategyProvider.class, ClassLoader.getSystemClassLoader());
        for (IAIStrategyProvider provider : strategyProvider) {
            takeLoanStrategies.addAll(provider.getTakeLoanStrategies());
        }
        return takeLoanStrategies;
    }

    public List<IAIConstructionSelectionStrategyType> getConstructionSelectionStrategies() {
        ArrayList<IAIConstructionSelectionStrategyType> constructionSelectionStrategies = new ArrayList<IAIConstructionSelectionStrategyType>();
        ServiceLoader<IAIStrategyProvider> strategyProvider = ServiceLoader.load(IAIStrategyProvider.class, ClassLoader.getSystemClassLoader());
        for (IAIStrategyProvider provider : strategyProvider) {
            constructionSelectionStrategies.addAll(provider.getConstructionSelectionStrategies());
        }
        return constructionSelectionStrategies;
    }

    public List<IAICaptainHireStrategyType> getCaptainHireStrategies() {
        ArrayList<IAICaptainHireStrategyType> captainHireStrategies = new ArrayList<IAICaptainHireStrategyType>();
        ServiceLoader<IAIStrategyProvider> strategyProvider = ServiceLoader.load(IAIStrategyProvider.class, ClassLoader.getSystemClassLoader());
        for (IAIStrategyProvider provider : strategyProvider) {
            captainHireStrategies.addAll(provider.getCaptainHireStrategies());
        }
        return captainHireStrategies;
    }

    public List<IAIGuildJoinStrategyType> getGuildJoinStrategies() {
        ArrayList<IAIGuildJoinStrategyType> joinStrategies = new ArrayList<IAIGuildJoinStrategyType>();
        ServiceLoader<IAIStrategyProvider> strategyProvider = ServiceLoader.load(IAIStrategyProvider.class, ClassLoader.getSystemClassLoader());
        for (IAIStrategyProvider provider : strategyProvider) {
            joinStrategies.addAll(provider.getGuildJoinStrategies());
        }
        return joinStrategies;
    }

    public List<IAIEventDecisionStrategyType> getEventDecisionStrategies() {
        ArrayList<IAIEventDecisionStrategyType> eventDecissionStrategies = new ArrayList<IAIEventDecisionStrategyType>();
        ServiceLoader<IAIStrategyProvider> strategyProvider = ServiceLoader.load(IAIStrategyProvider.class, ClassLoader.getSystemClassLoader());
        for (IAIStrategyProvider provider : strategyProvider) {
            eventDecissionStrategies.addAll(provider.getEventDecisionStrategies());
        }
        return eventDecissionStrategies;
    }
}

