/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.factory;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.PlayerInteractionFactory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.IStorage;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.impl.Storage;
import ch.sahits.game.openpatrician.model.building.impl.TradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.BuildingFinished;
import ch.sahits.game.openpatrician.model.impl.BalanceSheet;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class BuildingFactory {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private PlayerInteractionFactory interactionFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    public IStorage createStorage(IPlayer owner, ICity city) {
        Storage storage = (Storage)this.context.getBean("storage", new Object[]{owner, city});
        return storage;
    }

    public ITradingOffice createTradingOffice(IPlayer owner, ICity city, int value) {
        for (IBuilding building : city.getBuildings()) {
            if (building.getOwner() != owner || !(building instanceof ITradingOffice)) continue;
            throw new IllegalStateException("The player may only obtain one trading office per city");
        }
        IStorage storage = this.createStorage(owner, city);
        BalanceSheet lastWeek = null;
        BalanceSheet thisWeek = null;
        ICity hometown = owner.getHometown();
        if (hometown.equals(city)) {
            lastWeek = this.interactionFactory.createInitialBalanceSheet(city, owner);
            thisWeek = this.interactionFactory.createBalanceSheetFromPreviousWeek(lastWeek);
        } else {
            Optional mainOffice = owner.findTradingOffice(hometown);
            Preconditions.checkArgument((boolean)mainOffice.isPresent(), (Object)"There has to be a trading office in the hometown");
            lastWeek = ((ITradingOffice)mainOffice.get()).getBalanceLastWeek();
            thisWeek = ((ITradingOffice)mainOffice.get()).getCurrentWeek();
        }
        TradingOffice office = (TradingOffice)this.context.getBean("tradingOffice", new Object[]{owner, city, value, storage, lastWeek, thisWeek});
        city.build((IBuilding)office);
        this.clientServerEventBus.post((Object)new BuildingFinished((IBuilding)office, owner, city));
        return office;
    }
}

