/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.factory;

import ch.sahits.game.graphic.image.PortraitProvider;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.MapSegmentImageFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.IChurch;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IFutureTowns;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.LoanerList;
import ch.sahits.game.openpatrician.model.city.cityhall.CityHallList;
import ch.sahits.game.openpatrician.model.city.cityhall.IAcceptedAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.IBowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.IBuildLandPassage;
import ch.sahits.game.openpatrician.model.city.cityhall.ICapturePirateNest;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHallNotice;
import ch.sahits.game.openpatrician.model.city.cityhall.ICrossbowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.IFoundNewSettlement;
import ch.sahits.game.openpatrician.model.city.cityhall.IHelpCity;
import ch.sahits.game.openpatrician.model.city.cityhall.IHuntPirate;
import ch.sahits.game.openpatrician.model.city.cityhall.IMusketeer;
import ch.sahits.game.openpatrician.model.city.cityhall.IPikemen;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CapturePirateNest;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Treasury;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.model.city.impl.LoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanRequest;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.impl.Citizen;
import ch.sahits.game.openpatrician.model.map.ILandBridge;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.personal.impl.SpouseData;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javafx.collections.ObservableList;
import javafx.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class StateFactory {
    @Value(value="${loaner.max.request}")
    private int maxRequests = 6;
    @Value(value="${loaner.max.loans}")
    private int maxLoanProposal = 3;
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private PortraitProvider portraits;
    private static RandomNameLoader maleFirstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader femaleFirstNameLoader = new RandomNameLoader("female_firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");
    public static final double NOTICE_WARE_PRICE_FACTOR = 1.15;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private MapService citiesInteractionService;
    @Autowired
    private Random rnd;
    @Autowired
    private MapSegmentImageFactory segmentImageFactory;
    @Autowired
    private Date date;
    @Autowired
    private IMap map;
    @Autowired
    private SeaPiratesState pirateState;
    @Autowired
    private CityHallList cityHalls;
    @Autowired
    private GuildList guildList;
    @Autowired
    private LoanerList loaners;

    public IShipyard createShipYard(ICity city) {
        return (IShipyard)this.context.getBean("shipyardState", new Object[]{city});
    }

    public TavernState createTavernState(ICity city) {
        return (TavernState)this.context.getBean("tavernState", new Object[]{city});
    }

    public ILoaner createLoaner(ICity city) {
        ILoaner loaner = (ILoaner)this.context.getBean("loanerState", new Object[]{city});
        this.updateLoanerRequestsAndLoans(loaner);
        this.loaners.add(loaner);
        return loaner;
    }

    public void updateLoanerRequestsAndLoans(ILoaner loaner) {
        loaner.clearOldRequests();
        while (loaner.getRequests().size() < this.maxRequests) {
            this.createNewLoanRequest(loaner, loaner.getCity());
        }
        while (loaner.getLoanProposals().size() < this.maxLoanProposal) {
            this.createNewLoanProposal(loaner);
        }
    }

    private void createNewLoanProposal(ILoaner loaner) {
        int duration = this.rnd.nextInt(30) + 5;
        double interesst = this.rnd.nextDouble() + 1.0;
        interesst = interesst / 100.0 + 1.0;
        int amount = this.rnd.nextInt(2500) * 10 + 5000;
        LoanProposal proposal = LoanProposal.builder().amount(amount).durationInWeeks(duration).interest(interesst).build();
        loaner.add(proposal);
    }

    private void createNewLoanRequest(ILoaner loaner, ICity city) {
        DateTime now = this.date.getCurrentDate();
        int duration = this.rnd.nextInt(50) + 10;
        int rankIndexBound = ESocialRank.values().length - 2;
        int rankIndex = this.rnd.nextInt(rankIndexBound);
        ESocialRank rank = ESocialRank.values()[rankIndex];
        Citizen citizen = new Citizen(lastNameLoader.getRandomName(), maleFirstNameLoader.getRandomName(), rank, city);
        int amount = (this.rnd.nextInt(10000) + 1000) * (rankIndex + 1);
        LoanRequest request = LoanRequest.builder().citizen((ICitizen)citizen).durationInWeeks(duration).issued(now).sum(amount).build();
        loaner.add(request);
    }

    public ICityHall createCityHall(ICity city) {
        ArrayList<ICitizen> candidates = new ArrayList<ICitizen>();
        ITreasury treasury = (ITreasury)this.context.getBean(Treasury.class);
        treasury.cashProperty().setValue((Number)this.rnd.nextInt(5000));
        treasury.currentPropertyTaxProperty().setValue((Number)30);
        treasury.currentHeadTaxValueProperty().setValue((Number)8);
        ArrayList<Object> guards = new ArrayList<Object>();
        ObservableList<ICityHallNotice> notices = this.citiesInteractionService.createNotices(city);
        int population = city.getPopulationBinding().get();
        int nbCouncilmen = this.citiesInteractionService.getMaxNumberOfGuards(population);
        ArrayList<ICitizen> councilmen = new ArrayList<ICitizen>();
        ICitizen mayor = null;
        for (ICitizen citizen : city.getCitizen()) {
            ESocialRank rank;
            if (councilmen.size() >= nbCouncilmen || !citizen.getHometown().equals(city) || (rank = citizen.getRank()) != ESocialRank.COUNCILMAN && rank != ESocialRank.PATRICIAN && rank != ESocialRank.MAYOR && rank != ESocialRank.ALDERMAN) continue;
            councilmen.add(citizen);
            if (rank != ESocialRank.MAYOR) continue;
            mayor = citizen;
        }
        if (mayor == null) {
            mayor = this.createCitizen(city, ESocialRank.MAYOR);
            if (councilmen.size() >= nbCouncilmen) {
                ICitizen iCitizen = (ICitizen)councilmen.remove(councilmen.size() - 1);
            }
            councilmen.add(mayor);
            city.getCitizen().add(mayor);
        }
        while (councilmen.size() < nbCouncilmen) {
            ICitizen citizen = this.createCitizen(city, ESocialRank.COUNCILMAN);
            councilmen.add(citizen);
            city.getCitizen().add(citizen);
        }
        candidates.add(mayor);
        int nbCandidates = Math.min(4, nbCouncilmen);
        while (candidates.size() < nbCandidates) {
            int index = this.rnd.nextInt(councilmen.size());
            ICitizen candidate = (ICitizen)councilmen.get(index);
            if (candidates.contains(candidate)) continue;
            candidates.add(candidate);
        }
        int nbGuards = this.getNumberOfGuards(population);
        for (int i = 0; i < nbGuards / 2; ++i) {
            guards.add(this.createPikeman());
        }
        while (guards.size() < nbGuards) {
            guards.add(this.createBowman());
        }
        CityHall cityHall = (CityHall)this.context.getBean("cityHall", new Object[]{notices, candidates, treasury, guards, city, councilmen});
        cityHall.setMayor(mayor);
        DateTime election = this.date.getCurrentDate().plusDays(this.rnd.nextInt(600));
        cityHall.setElectionDate(election);
        cityHall.setMaxNumberMilita(nbGuards);
        this.cityHalls.add((ICityHall)cityHall);
        return cityHall;
    }

    public IGuild createGuild(ICity city) {
        IGuild guild = (IGuild)this.context.getBean("guild", new Object[]{city});
        this.guildList.add(guild);
        return guild;
    }

    private int getNumberOfGuards(int population) {
        return population / 100;
    }

    public ICitizen createCitizen(ICity hometown, ESocialRank rank) {
        String firstName = maleFirstNameLoader.getRandomName();
        String lastName = lastNameLoader.getRandomName();
        return (ICitizen)this.context.getBean("citizen", new Object[]{lastName, firstName, rank, hometown});
    }

    public IPikemen createPikeman() {
        return (IPikemen)this.context.getBean(IPikemen.class);
    }

    public IBowmen createBowman() {
        return (IBowmen)this.context.getBean(IBowmen.class);
    }

    public ICrossbowmen createCrossbowman() {
        return (ICrossbowmen)this.context.getBean(ICrossbowmen.class);
    }

    public IMusketeer createMusketieer() {
        return (IMusketeer)this.context.getBean(IMusketeer.class);
    }

    public IAldermanOffice createAldermanOffice() {
        return (IAldermanOffice)this.context.getBean(IAldermanOffice.class);
    }

    public Optional<IHelpCity> createHelpCityAldermanTask() {
        ArrayList cities = new ArrayList(this.map.getCities());
        Collections.shuffle(cities);
        for (ICity city : cities) {
            int population = city.getPopulationBinding().get();
            if (population >= 2000) continue;
            int duration = (2000 - population) / 3;
            IHelpCity task = (IHelpCity)this.context.getBean("helpCity", new Object[]{duration, city});
            return Optional.of(task);
        }
        return Optional.empty();
    }

    public Optional<IHelpCity> createHelpCityAldermanTask(IAldermanOffice office) {
        List workedOnTasks = office.getWorkedOnTasks();
        ArrayList<ICity> helpTasks = new ArrayList<ICity>();
        for (IAcceptedAldermanTask workedOnTask : workedOnTasks) {
            if (!(workedOnTask.getTask() instanceof IHelpCity)) continue;
            helpTasks.add(((IHelpCity)workedOnTask.getTask()).getCity());
        }
        ArrayList cities = new ArrayList(this.map.getCities());
        Collections.shuffle(cities);
        for (ICity city : cities) {
            int population;
            if (helpTasks.contains(city) || (population = city.getPopulationBinding().get()) >= 2000) continue;
            int duration = (2000 - population) / 3;
            IHelpCity task = (IHelpCity)this.context.getBean("helpCity", new Object[]{duration, city});
            return Optional.of(task);
        }
        return Optional.empty();
    }

    public Optional<IFoundNewSettlement> createNewSettlementEledermanTask(IAldermanOffice office) {
        List workedOnTasks = office.getWorkedOnTasks();
        ArrayList<String> tasks = new ArrayList<String>();
        for (IAcceptedAldermanTask workedOnTask : workedOnTasks) {
            if (!(workedOnTask.getTask() instanceof IFoundNewSettlement)) continue;
            tasks.add(((IFoundNewSettlement)workedOnTask.getTask()).getName());
        }
        ArrayList cities = new ArrayList(this.map.getFutureTowns());
        Collections.shuffle(cities);
        for (IFutureTowns city : cities) {
            if (tasks.contains(city.getName())) continue;
            int duration = 720;
            IFoundNewSettlement task = (IFoundNewSettlement)this.context.getBean("foundNewSettlement", new Object[]{duration, city.getLocation(), city.getName(), city.isRiver()});
            return Optional.of(task);
        }
        return Optional.empty();
    }

    public Optional<IBuildLandPassage> createNewLandBridgeAldermanTask(IAldermanOffice office) {
        Pair pair;
        List workedOnTasks = office.getWorkedOnTasks();
        ArrayList<Pair> tasks = new ArrayList<Pair>();
        for (IAcceptedAldermanTask workedOnTask : workedOnTasks) {
            if (!(workedOnTask.getTask() instanceof IBuildLandPassage)) continue;
            IBuildLandPassage concreteTask = (IBuildLandPassage)workedOnTask.getTask();
            pair = new Pair((Object)concreteTask.getFromCity(), (Object)concreteTask.getToCity());
            tasks.add(pair);
        }
        ArrayList landBridges = new ArrayList(this.map.getLandbridges());
        Collections.shuffle(landBridges);
        for (ILandBridge landBridge : landBridges) {
            pair = new Pair((Object)landBridge.getFrom(), (Object)landBridge.getTo());
            if (tasks.contains(pair)) continue;
            int duration = 360;
            IBuildLandPassage newPassage = (IBuildLandPassage)this.context.getBean("buildLandPassage", new Object[]{duration, landBridge.getFrom(), landBridge.getTo()});
            return Optional.of(newPassage);
        }
        return Optional.empty();
    }

    public Optional<IHuntPirate> createPirateHuntEledermanTask(IAldermanOffice office) {
        List workedOnTasks = office.getWorkedOnTasks();
        ArrayList<ISeaPirate> tasks = new ArrayList<ISeaPirate>();
        for (IAcceptedAldermanTask workedOnTask : workedOnTasks) {
            if (!(workedOnTask.getTask() instanceof IHuntPirate)) continue;
            tasks.add(((IHuntPirate)workedOnTask.getTask()).getPirate());
        }
        ArrayList pirates = new ArrayList(this.pirateState.getFreePirates());
        Collections.shuffle(pirates);
        for (ISeaPirate pirate : pirates) {
            if (tasks.contains(pirate)) continue;
            int duration = 60;
            IHuntPirate hunt = (IHuntPirate)this.context.getBean("huntPirate", new Object[]{duration, pirate});
            return Optional.of(hunt);
        }
        return Optional.empty();
    }

    public Optional<ICapturePirateNest> createCapturePirateNestAldermanTask(IAldermanOffice office) {
        List workedOnTasks = office.getWorkedOnTasks();
        ArrayList<MapSegmentedImage> tasks = new ArrayList<MapSegmentedImage>();
        for (IAcceptedAldermanTask workedOnTask : workedOnTasks) {
            if (!(workedOnTask.getTask() instanceof ICapturePirateNest)) continue;
            tasks.add(((ICapturePirateNest)workedOnTask.getTask()).getPirateNestMap());
        }
        MapSegmentedImage map = this.segmentImageFactory.getRandomPirateNest();
        if (tasks.contains(map)) {
            return Optional.empty();
        }
        int duration = 180;
        CapturePirateNest task = (CapturePirateNest)this.context.getBean("capturePirateNest", new Object[]{duration, map.getLocation(), map});
        return Optional.of(task);
    }

    public IChurch createChurch() {
        return (IChurch)this.context.getBean(IChurch.class);
    }

    public ISpouseData createSpouse(MarriageBrokerAnnouncementState state, IPlayer player) {
        String firstName = state.isGenderMale() ? femaleFirstNameLoader.getRandomName() : maleFirstNameLoader.getRandomName();
        ICity birthPlace = (ICity)this.map.getCities().get(this.rnd.nextInt(this.map.getNumberCities()));
        DateTime birthDate = state.getDate().minusYears(this.rnd.nextInt(15) + 15).minusDays(this.rnd.nextInt(365));
        int conHer = 0;
        int conYour = 0;
        int popHer = 0;
        int popYour = 0;
        ESocialRank rank = player.getRank();
        switch (rank) {
            case CHANDLER: {
                popHer = 1000;
                break;
            }
            case BARGAINER: {
                popHer = 2000;
                break;
            }
            case MERCHANT: {
                popHer = 2500;
                conHer = 1;
                break;
            }
            case TRADESMAN: {
                popHer = 3500;
                conHer = 1;
                break;
            }
            case COUNCILMAN: {
                popHer = 4000;
                conHer = 2;
                break;
            }
            case PATRICIAN: {
                popHer = 6000;
                conHer = 3;
                popYour = 1000;
                conYour = 1;
                break;
            }
            case MAYOR: {
                popHer = 7000;
                conHer = 3;
                popYour = 2000;
                conYour = 1;
                break;
            }
            case ALDERMAN: {
                popHer = 10000;
                conHer = 3;
                popYour = 4000;
                conYour = 3;
            }
        }
        if (player.getHometown().equals(birthPlace)) {
            popYour = Math.max(popYour, popHer);
            conYour = Math.max(conYour, conHer);
        }
        String portrait = state.isGenderMale() ? this.portraits.getRandomFemalePortraitResourceName() : this.portraits.getRandomMalePortraitResourceName();
        SpouseData spouse = SpouseData.builder().male(!state.isGenderMale()).name(firstName).lastName(lastNameLoader.getRandomName()).birthplace(birthPlace).birthDate(birthDate).conHer(conHer).conYour(conYour).popHer(popHer).popYour(popYour).portraitResourceName(portrait).build();
        return spouse;
    }
}

