/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.clientserverinterface.model.LinearPathSegment;
import ch.sahits.game.openpatrician.clientserverinterface.model.LinkedPathItem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.LinkedList;
import java.util.List;
import javafx.geometry.Point2D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class PathInterpolator {
    @XStreamOmitField
    private static final Logger LOGGER = LogManager.getLogger(PathInterpolator.class);
    private double totalLength = 0.0;
    private double traveldFraction = 0.0;
    private double travelFractionPerTick = 0.0;
    @ListType(value=Point2D.class)
    private final List<Point2D> originalPath;
    @ListType(value=LinkedPathItem.class)
    private LinkedList<LinkedPathItem<LinearPathSegment>> segments = new LinkedList();
    private LinkedPathItem<LinearPathSegment> currentSegment;

    public PathInterpolator(List<Point2D> originalPath) {
        this.originalPath = originalPath;
        this.calculateSegments();
    }

    @VisibleForTesting
    void calculateSegments() {
        LinearPathSegment segment;
        this.segments.clear();
        Point2D current = this.originalPath.get(0);
        this.totalLength = 0.0;
        for (int i = 1; i < this.originalPath.size(); ++i) {
            Point2D point2D = this.originalPath.get(i);
            segment = new LinearPathSegment(current, point2D);
            current = point2D;
            segment.setLengthToStart(this.totalLength);
            this.totalLength += segment.getLength();
            LinkedPathItem<LinearPathSegment> item = new LinkedPathItem<LinearPathSegment>(segment);
            if (i > 1) {
                this.segments.getLast().setNext(item);
            }
            this.segments.add(item);
        }
        for (LinkedPathItem linkedPathItem : this.segments) {
            segment = (LinearPathSegment)linkedPathItem.getData();
            double fraction = segment.getLengthToStart() / this.totalLength;
            segment.setFractionAtStart(fraction);
        }
        this.currentSegment = this.segments.getFirst();
    }

    public Point2D interpolate(double frac) {
        Preconditions.checkArgument((frac >= 0.0 && frac <= 1.0 ? 1 : 0) != 0, (Object)("Fraction must be between [0,1] inclusive. frac=" + frac));
        double pathLengthToFrac = this.totalLength * frac;
        Preconditions.checkArgument((pathLengthToFrac >= this.currentSegment.getData().getLengthToStart() ? 1 : 0) != 0, (Object)"The path to the new position must be larger than the previous one");
        this.moveCurrentSegment(frac);
        LinearPathSegment data = this.currentSegment.getData();
        double lengthIntoSegment = pathLengthToFrac - data.getLengthToStart();
        double frationIntoSegment = lengthIntoSegment / data.getLength();
        Point2D direction = data.getEnd().subtract(data.getStart());
        Point2D newLocation = data.getStart().add(direction.multiply(frationIntoSegment));
        this.traveldFraction = frac;
        if (this.traveldFraction > 1.0) {
            this.traveldFraction = 1.0;
        }
        LOGGER.trace("Interpolate path by {} to {}", new Object[]{frac, newLocation});
        return newLocation;
    }

    private void moveCurrentSegment(double frac) {
        if (this.currentSegment.equals(this.segments.getLast())) {
            return;
        }
        double fractionAtStartNextSegment = ((LinearPathSegment)this.currentSegment.getNext().getData()).getFractionAtStart();
        if (frac < fractionAtStartNextSegment) {
            return;
        }
        this.currentSegment = this.currentSegment.getNext();
        this.moveCurrentSegment(frac);
    }

    public double getTotalLength() {
        return this.totalLength;
    }

    public double getTraveldFraction() {
        return this.traveldFraction;
    }

    public double getTravelFractionPerTick() {
        return this.travelFractionPerTick;
    }

    public void setTravelFractionPerTick(double travelFractionPerTick) {
        this.travelFractionPerTick = travelFractionPerTick;
    }
}

