/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.util.IPropertyInitializer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public abstract class PropertyInitializer
implements IPropertyInitializer {
    private final Properties properties = new Properties();
    private String keySuffix;

    public PropertyInitializer(String propertyFileName) throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(propertyFileName);
        if (inputStream == null) {
            throw new FileNotFoundException("property file '" + propertyFileName + "' not found in the classpath");
        }
        this.properties.load(inputStream);
        this.keySuffix = "chandler";
    }

    public int getIntValue(String baseKey) {
        return Integer.parseInt(this.getValue(baseKey));
    }

    public double getDoubleValue(String baseKey) {
        return Double.parseDouble(this.getValue(baseKey));
    }

    public String getValue(String baseKey) {
        return (String)this.properties.get(this.composeKey(baseKey));
    }

    private String composeKey(String baseKey) {
        return baseKey + "." + this.keySuffix;
    }

    public void setKeySuffix(String keySuffix) {
        this.keySuffix = keySuffix;
    }
}

