/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.ICog;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.ICrayer;
import ch.sahits.game.openpatrician.model.ship.IGroupableVessel;
import ch.sahits.game.openpatrician.model.ship.IHolk;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ShipService {
    public static final int CITY_RADIUS = 10;
    @Value(value="${ship.weapon.strength.factor}")
    private int bigWeaponStrengthFactor = 2;
    @Autowired
    private IMap map;

    public int calculateShipsWeaponsStrength(INavigableVessel ship) {
        int strength = 0;
        strength += ship.getWeaponAmount((IWeapon)EWeapon.BALLISTA_BIG) * this.bigWeaponStrengthFactor;
        strength += ship.getWeaponAmount((IWeapon)EWeapon.TREBUCHET_BIG) * this.bigWeaponStrengthFactor;
        strength += ship.getWeaponAmount((IWeapon)EWeapon.CANNON) * this.bigWeaponStrengthFactor;
        strength += ship.getWeaponAmount((IWeapon)EWeapon.BOMBARD) * this.bigWeaponStrengthFactor;
        strength += ship.getWeaponAmount((IWeapon)EWeapon.BALLISTA_SMALL);
        return strength += ship.getWeaponAmount((IWeapon)EWeapon.TREBUCHET_SMALL);
    }

    public Optional<INavigableVessel> findShipByUuid(List<INavigableVessel> fleet, String uuid) {
        for (INavigableVessel vessel : fleet) {
            if (!uuid.equals(vessel.getUuid())) continue;
            return Optional.of(vessel);
        }
        return Optional.empty();
    }

    public Optional<ICity> findCity(INavigableVessel vessel) {
        Point2D location = vessel.getLocation();
        for (ICity city : this.map.getCities()) {
            if (!city.getCoordinates().equals((Object)location)) continue;
            return Optional.of(city);
        }
        return Optional.empty();
    }

    public int calculateRepairCosts(ICity city, IShip ship) {
        IShipyard state = city.getCityState().getShipyardState();
        int damage = (int)Math.rint((double)(100 - ship.getDamage()) / 100.0);
        int repairTime = state.calculateRepairTime(ship.getShipType());
        int materialCosts = state.calculateRepairMaterialCosts(ship, damage);
        return state.calculateRepairCosts(repairTime *= damage, materialCosts);
    }

    public int calculateRepairCostsVessel(ICity city, INavigableVessel vessel) {
        int sum = 0;
        if (vessel instanceof IConvoy) {
            for (IShip ship : ((IConvoy)vessel).getShips()) {
                sum += this.calculateRepairCosts(city, ship);
            }
        } else if (vessel instanceof IShipGroup) {
            for (IShip ship : ((IShipGroup)vessel).getShips()) {
                sum += this.calculateRepairCosts(city, ship);
            }
        } else {
            throw new IllegalStateException("Unhandled vessel type: " + vessel.getClass().getName());
        }
        return sum;
    }

    public boolean checkNumberOfSailors(INavigableVessel vessel) {
        if (vessel instanceof IShip) {
            IShip ship = (IShip)vessel;
            return ship.getNumberOfSailors() >= ship.getMinNumberOfSailors();
        }
        IGroupableVessel group = (IGroupableVessel)vessel;
        for (IShip ship : group.getShips()) {
            if (this.checkNumberOfSailors((INavigableVessel)ship)) continue;
            return false;
        }
        return true;
    }

    public int getMinNumberOfSailors(INavigableVessel vessel) {
        if (vessel instanceof IShip) {
            return ((IShip)vessel).getMinNumberOfSailors();
        }
        IGroupableVessel ships = (IGroupableVessel)vessel;
        int number = 0;
        for (IShip ship : ships.getShips()) {
            number += ship.getMinNumberOfSailors();
        }
        return number;
    }

    public boolean isNearingCity(INavigableVessel vessel) {
        Point2D location = vessel.getLocation();
        for (ICity city : this.map.getCities()) {
            Point2D coordinates = city.getCoordinates();
            double distance = coordinates.distance(location);
            if (!(distance <= 10.0)) continue;
            return true;
        }
        return false;
    }

    public EShipType getShipType(INavigableVessel vessel) {
        if (vessel instanceof IHolk) {
            return EShipType.HOLK;
        }
        if (vessel instanceof ICog) {
            return EShipType.COG;
        }
        if (vessel instanceof ICrayer) {
            return EShipType.CRAYER;
        }
        if (vessel instanceof ISnaikka) {
            return EShipType.SNAIKKA;
        }
        if (vessel instanceof IGroupableVessel) {
            List ships = ((IGroupableVessel)vessel).getShips();
            HashSet<EShipType> types = new HashSet<EShipType>();
            for (IShip ship : ships) {
                types.add(this.getShipType((INavigableVessel)ship));
            }
            if (types.contains(EShipType.HOLK)) {
                return EShipType.HOLK;
            }
            if (types.contains(EShipType.COG)) {
                return EShipType.COG;
            }
            if (types.contains(EShipType.CRAYER)) {
                return EShipType.CRAYER;
            }
            if (types.contains(EShipType.SNAIKKA)) {
                return EShipType.SNAIKKA;
            }
        }
        return EShipType.HOLK;
    }
}

