/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TradeService {
    @Autowired
    private ComputablePriceV2 computablePrice;

    public void transferFromVesselToStorage(INavigableVessel vessel, IPlayer player, ICity city, Map<IWare, Integer> amounts) {
        Optional optOffice = player.findTradingOffice(city);
        Preconditions.checkArgument((boolean)optOffice.isPresent(), (Object)("There is no trading office for " + player.getName() + " " + player.getLastName() + " in " + city.getName()));
        for (IWare ware : amounts.keySet()) {
            int amount = amounts.get(ware);
            int avgPrice = vessel.getWare(ware).getAVGPrice();
            amount = vessel.unload(ware, amount);
            ((ITradingOffice)optOffice.get()).move(ware, amount, avgPrice);
        }
    }

    public void buyFromCityToStorage(ITradingOffice office, IPlayer player, ICity city, IWare ware, int amount) {
        ICompany company = player.getCompany();
        int availableAmountCity = city.getWare(ware).getAmount();
        if (availableAmountCity > 0) {
            int movedAmount;
            int amountToBuy = Math.min(availableAmountCity, amount);
            int avgPrice = this.computablePrice.buyPrice((ITradable)ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amountToBuy));
            long cash = company.getCash();
            if (cash < (long)avgPrice * (long)amountToBuy) {
                int amountAprox = (int)(cash / (long)avgPrice);
                if (amountAprox > 0) {
                    int newTempPrice;
                    int tempPrice = this.computablePrice.buyPrice((ITradable)ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amountAprox));
                    while ((long)(amountAprox * tempPrice + tempPrice) < cash && (long)(++amountAprox * (newTempPrice = this.computablePrice.buyPrice((ITradable)ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amountAprox)))) <= cash) {
                        tempPrice = newTempPrice;
                    }
                    avgPrice = tempPrice;
                    amountToBuy = amountAprox;
                } else {
                    return;
                }
            }
            if (amountToBuy != -(movedAmount = city.move(ware, -amountToBuy, (ICitizen)player))) {
                avgPrice = this.computablePrice.buyPrice((ITradable)ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(city.getWare(ware).getAmount() + movedAmount), (IntegerBinding)new ConstantIntegerBinding(movedAmount));
                amountToBuy = -movedAmount;
            }
            int loaded = office.move(ware, amountToBuy, avgPrice);
            company.updateCash((long)(-avgPrice * loaded));
        }
    }
}

