/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.spring;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.clientserverinterface.service.DifficultyPropertyInitializer;
import ch.sahits.game.openpatrician.clientserverinterface.service.PropertyInitializer;
import ch.sahits.game.openpatrician.event.SubscriptionLoggingExceptionHandler;
import ch.sahits.game.openpatrician.util.spring.DependentPropertyInitializer;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ClassCategory(value={EClassCategory.STARTUP})
@ComponentScan(value={"ch.sahits.game.openpatrician.clientserverinterface.service", "ch.sahits.game.openpatrician.clientserverinterface.model"})
public class ClientServerInterfaceCommonConfiguration {
    @Autowired
    private ApplicationContext context;

    @Bean
    public ExecutorService serverThreadPool() {
        int nThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        return Executors.newFixedThreadPool(nThreads);
    }

    @Bean
    public SubscriptionLoggingExceptionHandler subscriptionExceptionHandler() {
        return new SubscriptionLoggingExceptionHandler();
    }

    @Bean
    @Lazy
    public PropertyInitializer difficultyPropertyInitializer() {
        try {
            return new DifficultyPropertyInitializer();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Bean
    @UniquePrototype
    @Lazy
    public DependentPropertyInitializer dependentPropertyInitializer(String suffix) {
        return new DependentPropertyInitializer();
    }
}

