/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.spring;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.event.SubscriptionLoggingExceptionHandler;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.spring.ClientServerInterfaceCommonConfiguration;
import ch.sahits.game.openpatrician.spring.ModelConfiguration;
import ch.sahits.game.openpatrician.util.PausableAsyncEventBus;
import ch.sahits.game.openpatrician.util.PausableSyncEventBus;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ClientServerInterfaceCommonConfiguration.class, ModelConfiguration.class})
@ClassCategory(value={EClassCategory.STARTUP})
public class ClientServerInterfaceStandaloneConfiguration {
    @Autowired
    @Qualifier(value="serverThreadPool")
    private Executor serverThreadPool;
    @Autowired
    private SubscriptionLoggingExceptionHandler subscriptionExceptionHandler;

    @Bean
    public PausableAsyncEventBus serverClientEventBus() {
        return new PausableAsyncEventBus(this.serverThreadPool, (SubscriberExceptionHandler)this.subscriptionExceptionHandler);
    }

    @Bean
    public PausableSyncEventBus syncServerClientEventBus() {
        return new PausableSyncEventBus((SubscriberExceptionHandler)this.subscriptionExceptionHandler);
    }

    @Bean
    public TimedUpdatableTaskList clientTimedTaskListener() {
        return new TimedUpdatableTaskList();
    }

    @Bean
    public AsyncEventBus timerEventBus() {
        return new AsyncEventBus(this.serverThreadPool, (SubscriberExceptionHandler)this.subscriptionExceptionHandler);
    }
}

