/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface;

import ch.sahits.game.openpatrician.clientserverinterface.event.SubscriptionLoggingExceptionHandler;
import ch.sahits.game.openpatrician.clientserverinterface.service.DifficultyPropertyInitializer;
import ch.sahits.game.openpatrician.clientserverinterface.service.PropertyInitializer;
import ch.sahits.game.openpatrician.model.ModelConfiguration;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.spring.DependentPropertyInitializer;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

@Configuration
@ClassCategory(value={EClassCategory.STARTUP})
@Import(value={ModelConfiguration.class})
@ComponentScan
public class ClientServerInterfaceCommonConfiguration {
    @Bean
    public ExecutorService serverThreadPool() {
        int nThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        return Executors.newFixedThreadPool(nThreads);
    }

    @Bean
    public SubscriptionLoggingExceptionHandler subscriptionExceptionHandler() {
        return new SubscriptionLoggingExceptionHandler();
    }

    @Bean
    @Lazy
    public PropertyInitializer difficultyPropertyInitializer() {
        try {
            return new DifficultyPropertyInitializer();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Bean
    @Lazy
    public DependentPropertyInitializer dependentPropertyInitializer() {
        return new DependentPropertyInitializer();
    }
}

