/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.CelebrationState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.CelebrationSuccess;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class MarriageCelebrationState
extends CelebrationState {
    private ISpouseData spouseData;

    private MarriageCelebrationState(CelebrationSuccess success, int amountGuests, LocalDateTime date, String location, ISpouseData spouseData) {
        super(success, amountGuests, date, location);
        this.spouseData = spouseData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ISpouseData getSpouseData() {
        return this.spouseData;
    }

    public static class Builder
    extends CelebrationState.Builder {
        private ISpouseData spouseData;

        public Builder spouseData(ISpouseData spouseData) {
            this.spouseData = spouseData;
            return this;
        }

        @Override
        public Builder success(CelebrationSuccess success) {
            super.success(success);
            return this;
        }

        @Override
        public Builder amountGuests(int amountGuests) {
            super.amountGuests(amountGuests);
            return this;
        }

        @Override
        public Builder date(LocalDateTime date) {
            super.date(date);
            return this;
        }

        @Override
        public Builder location(String location) {
            super.location(location);
            return this;
        }

        @Override
        public MarriageCelebrationState build() {
            return new MarriageCelebrationState(this.success, this.amountGuests, this.date, this.location, this.spouseData);
        }
    }
}

