/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.factory;

import ch.sahits.game.graphic.image.IMapSegmentImageCreator;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.CityFactory;
import ch.sahits.game.openpatrician.data.xmlmodel.Map;
import ch.sahits.game.openpatrician.data.xmlmodel.MapSegments;
import ch.sahits.game.openpatrician.data.xmlmodel.PirateHideout;
import ch.sahits.game.openpatrician.data.xmlmodel.PirateNest;
import ch.sahits.game.openpatrician.data.xmlmodel.SunkenTreasure;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.map.PirateMapSegmentImage;
import ch.sahits.game.openpatrician.model.map.TreasureMapSegmentImage;
import ch.sahits.game.openpatrician.model.server.MapLocationDetectionModel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.geometry.Point2D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class MapSegmentImageFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private Random rnd;
    @Autowired
    private CityFactory cityFactory;
    @Autowired
    private IMapSegmentImageCreator imageCreator;
    @Autowired
    private MapLocationDetectionModel dataModel;
    @ListType(value=MapSegmentedImage.class)
    private List<MapSegmentedImage> pirateHideOuts;
    @ListType(value=MapSegmentedImage.class)
    private List<MapSegmentedImage> sunkShips;

    public void initializeImages() {
        Map map = this.cityFactory.getMap();
        this.pirateHideOuts = new ArrayList<MapSegmentedImage>();
        this.sunkShips = new ArrayList<MapSegmentedImage>();
        MapSegments mapSegments = map.getMapSegments();
        this.imageCreator.loadMap(map.getImageName());
        for (PirateNest pirateNest : mapSegments.getPirateNest()) {
            try {
                this.imageCreator.createMapSegment(pirateNest, map.getImageName());
            }
            catch (IOException e) {
                this.logger.error("Failed to create pirate map segment.", (Throwable)e);
            }
        }
        for (SunkenTreasure sunkenTreasure : mapSegments.getSunkenTreasure()) {
            try {
                this.imageCreator.createMapSegment(sunkenTreasure, map.getImageName());
            }
            catch (IOException e) {
                this.logger.error("Failed to create pirate map segment.", (Throwable)e);
            }
            this.sunkShips.add((MapSegmentedImage)new TreasureMapSegmentImage(sunkenTreasure.getImgName(), new Point2D((double)sunkenTreasure.getX(), (double)sunkenTreasure.getX()), sunkenTreasure.getTreasure()));
        }
        for (PirateHideout hideout : mapSegments.getPirateHideout()) {
            try {
                this.imageCreator.createMapSegment(hideout, map.getImageName());
            }
            catch (IOException e) {
                this.logger.error("Failed to create pirate map segment.", (Throwable)e);
            }
            this.pirateHideOuts.add((MapSegmentedImage)new PirateMapSegmentImage(hideout.getImgName(), new Point2D((double)hideout.getX(), (double)hideout.getX()), 1, hideout.getName()));
        }
    }

    public MapSegmentedImage getRandomPirateNest() {
        MapSegmentedImage mapImage = this.getRandomImage(this.pirateHideOuts);
        return this.checkMapUnused(mapImage, this.pirateHideOuts);
    }

    private MapSegmentedImage checkMapUnused(MapSegmentedImage mapImage, List<MapSegmentedImage> segmentList) {
        while (this.dataModel.containsSegment(mapImage)) {
            mapImage = this.getRandomImage(segmentList);
        }
        return mapImage;
    }

    public MapSegmentedImage getRandomTreasureNest() {
        MapSegmentedImage mapImage = this.getRandomImage(this.sunkShips);
        return this.checkMapUnused(mapImage, this.sunkShips);
    }

    private MapSegmentedImage getRandomImage(List<MapSegmentedImage> imgList) {
        MapSegmentedImage img = imgList.get(this.rnd.nextInt(imgList.size()));
        int availableSegment = this.rnd.nextInt(9);
        img.addSegment(availableSegment);
        return img;
    }
}

