/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class LinearDeadlinePremiumCalculator
implements Supplier<Integer> {
    private final LocalDateTime start;
    private final LocalDateTime end;
    private final int maxPremium;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private DateService dateService;

    public LinearDeadlinePremiumCalculator(LocalDateTime start, LocalDateTime end, int maxPremium) {
        this.start = start;
        this.end = end;
        this.maxPremium = maxPremium;
    }

    @Override
    public Integer get() {
        LocalDateTime now = this.date.getCurrentDate();
        if (now.isAfter(this.end)) {
            return 0;
        }
        double percentagePassed = this.dateService.getPercentageBetweenDates(now, this.end);
        return (int)Math.rint((double)this.maxPremium * (1.0 - percentagePassed));
    }
}

