/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.sea.BlockadeState;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class MapProxy {
    @Autowired
    private IMap map;
    @Autowired
    private BlockadeState blockade;
    @Autowired
    private ShipService shipService;

    public List<ICity> getAllCities() {
        return this.map.getCities();
    }

    public List<ICity> getAllReachableCities(INavigableVessel vessel) {
        ArrayList<ICity> cities = new ArrayList<ICity>(this.map.getCities());
        return this.getReachableCities(vessel, cities);
    }

    public List<ICity> getAllUnreachableCities(INavigableVessel vessel) {
        List<ICity> cities = this.getAllCities();
        cities.removeAll(this.getAllReachableCities(vessel));
        return cities;
    }

    private List<ICity> getReachableCities(INavigableVessel vessel, List<ICity> cities) {
        EShipType type = this.shipService.getShipType(vessel);
        if (type == EShipType.CRAYER || type == EShipType.SNAIKKA) {
            return cities;
        }
        Iterator<ICity> iterator = cities.iterator();
        while (iterator.hasNext()) {
            ICity city = iterator.next();
            if (!city.isRiverCity()) continue;
            iterator.remove();
        }
        return cities;
    }

    public List<ICity> getAllReachableNonBlockadedCities(INavigableVessel vessel) {
        List<ICity> cities = this.getAllNonBlockedCities();
        return this.getReachableCities(vessel, cities);
    }

    public List<ICity> getAllNonBlockedCities() {
        ArrayList<ICity> cities = new ArrayList<ICity>(this.map.getCities());
        for (Map.Entry entry : this.blockade.entrySet()) {
            cities.remove(entry.getKey());
        }
        return cities;
    }
}

