/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class OutriggerService {
    @Autowired
    private Date date;
    @Autowired
    private IMap map;

    public int getRequiredWeaponStrength(ICity city) {
        double xLocation = city.getCoordinates().getX();
        double westwardFactor = 1.0 + (this.map.getDimension().getWidth() - xLocation) / this.map.getDimension().getWidth();
        int currentYear = this.date.getCurrentDate().getYear();
        if (currentYear <= 1200) {
            return (int)westwardFactor;
        }
        int from1200 = currentYear - 1200;
        double yearFactor = (double)from1200 * 6.0 / 200.0;
        return (int)(westwardFactor * yearFactor);
    }

    public int getWeeklyReund(ICity city) {
        double xLocation = city.getCoordinates().getX();
        double westwardFactor = 1.0 + (this.map.getDimension().getWidth() - xLocation) / this.map.getDimension().getWidth();
        int currentYear = this.date.getCurrentDate().getYear();
        if (currentYear <= 1200) {
            return (int)westwardFactor * 30;
        }
        int from1200 = currentYear - 1200;
        double yearFactor = (double)from1200 * 6.0 / 200.0;
        return (int)(westwardFactor * yearFactor) * 30;
    }
}

