/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWorkShop;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ProductionStorage;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.product.ProductionChain;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class PlayerProductionService {
    private static final double ONE_DAY_OF_WEEK = 0.14285714285714285;
    @Autowired
    private ProductionChain productionChain;
    @Autowired
    private TradeService tradeService;

    public void buyWareForProductionOneDay(ITradingOffice office) {
        ICity city = office.getCity();
        IPlayer player = office.getOwner();
        List workshops = player.findBuildings(city, IWorkShop.class);
        for (IWorkShop workshop : workshops) {
            IWare producedWare = workshop.getProducableWare();
            List required = this.productionChain.getRequiredWares(producedWare);
            ProductionStorage storage = workshop.getStorage();
            for (IWare ware : required) {
                double requiredAmount = this.productionChain.getRequiredAmount(producedWare, ware) * 0.14285714285714285;
                if (!(storage.getStored(ware) < requiredAmount)) continue;
                int amount2Transfer = (int)Math.ceil(requiredAmount -= storage.getStored(ware));
                int amountInTradingOffice = office.getWare(ware).getAmount();
                if (amountInTradingOffice < amount2Transfer) {
                    int amount2Buy = amount2Transfer - amountInTradingOffice;
                    this.tradeService.buyFromCityToStorage(office, player, city, ware, amount2Buy, Optional.empty(), Optional.empty());
                }
                int avgPrice = office.getWare(ware).getAVGPrice();
                int moved = office.move(ware, -amount2Transfer, avgPrice);
                storage.transfer(ware, (double)(-moved), (double)avgPrice);
            }
        }
    }

    public void produceWares(ITradingOffice office) {
        ICity city = office.getCity();
        IPlayer player = office.getOwner();
        List workshops = player.findBuildings(city, IWorkShop.class);
        Map<IWare, Long> workshopCount = workshops.stream().collect(Collectors.groupingBy(IWorkShop::getProducableWare, Collectors.counting()));
        HashMap<IWare, Double> productionFactors = new HashMap<IWare, Double>();
        for (IWare ware2 : workshopCount.keySet()) {
            int count = workshopCount.get(ware2).intValue();
            double produtionFactor = 1.0 + 0.1 * (double)(count / 5);
            productionFactors.put(ware2, produtionFactor);
        }
        for (IWorkShop workshop : workshops) {
            double efficientcyFactor = workshop.isProducingEfficienty() ? 1.0 : 0.5;
            IWare producedWare = workshop.getProducableWare();
            List required = this.productionChain.getRequiredWares(producedWare);
            ProductionStorage storage = workshop.getStorage();
            double producableAmountFactor = required.stream().mapToDouble(ware -> this.calculateProducableAmountFactor(storage, (IWare)ware, producedWare)).min().orElse(1.0);
            double staffingFactor = (double)workshop.getWorkers() * 1.0 / (double)workshop.getMaxWorkers();
            double requiredWareFactor = producableAmountFactor * staffingFactor;
            double produceWareAmount = this.productionChain.getProduction(producedWare) * requiredWareFactor * efficientcyFactor * (Double)productionFactors.get(producedWare);
            double wareCosts = required.stream().mapToDouble(ware -> this.calculateWareCost(producedWare, storage, requiredWareFactor, (IWare)ware)).sum();
            double productionCosts = wareCosts + (double)(workshop.getWorkers() * workshop.getSalaryPerWorker()) * 0.14285714285714285;
            double avgPrice = productionCosts / produceWareAmount;
            storage.transfer(producedWare, produceWareAmount, avgPrice);
            double stored = storage.getStored(producedWare);
            if (!(stored > 1.0)) continue;
            int transfer = (int)Math.floor(stored);
            office.move(producedWare, transfer, (int)Math.rint(avgPrice));
            storage.transfer(producedWare, (double)(-transfer), avgPrice);
        }
    }

    @VisibleForTesting
    double calculateWareCost(IWare producedWare, ProductionStorage storage, double requiredWareFactor, IWare ware) {
        double requiredForFullProduction = this.productionChain.getRequiredAmount(producedWare, ware) * 0.14285714285714285;
        double remove = -requiredForFullProduction * requiredWareFactor;
        double price = storage.getAvgPrice(ware);
        double moved = -storage.transfer(ware, remove, price);
        return moved * price;
    }

    @VisibleForTesting
    double calculateProducableAmountFactor(ProductionStorage storage, IWare requiredWare, IWare producableWare) {
        double stored = storage.getStored(requiredWare);
        double requiredForFullProduction = this.productionChain.getRequiredAmount(producableWare, requiredWare) * 0.14285714285714285;
        return Math.min(1.0, stored / requiredForFullProduction);
    }
}

