/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface;

import ch.sahits.game.openpatrician.clientserverinterface.ClientServerInterfaceCommonConfiguration;
import ch.sahits.game.openpatrician.clientserverinterface.event.SubscriptionLoggingExceptionHandler;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.utilities.PausableAsyncEventBus;
import ch.sahits.game.openpatrician.utilities.PausableSyncEventBus;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ClientServerInterfaceCommonConfiguration.class})
@ClassCategory(value={EClassCategory.STARTUP})
public class ClientServerInterfaceStandaloneConfiguration {
    @Autowired
    @Qualifier(value="serverThreadPool")
    private Executor serverThreadPool;
    @Autowired
    private SubscriptionLoggingExceptionHandler subscriptionExceptionHandler;

    @Bean
    public PausableAsyncEventBus serverClientEventBus() {
        return new PausableAsyncEventBus(this.serverThreadPool, (SubscriberExceptionHandler)this.subscriptionExceptionHandler);
    }

    @Bean
    public PausableSyncEventBus syncServerClientEventBus() {
        return new PausableSyncEventBus((SubscriberExceptionHandler)this.subscriptionExceptionHandler);
    }

    @Bean
    public TimedUpdatableTaskList clientTimedTaskListener() {
        return new TimedUpdatableTaskList();
    }

    @Bean
    public AsyncEventBus timerEventBus() {
        return new AsyncEventBus(this.serverThreadPool, (SubscriberExceptionHandler)this.subscriptionExceptionHandler);
    }
}

