/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class MarriageAnnouncementState
implements IDialogState {
    private LocalDateTime date;
    private ISpouseData spouse;
    private LocalDateTime weddingDate;
    private IPlayer player;

    public String getDialogBeanName() {
        return "marriageAnnouncementDialog";
    }

    MarriageAnnouncementState(LocalDateTime date, ISpouseData spouse, LocalDateTime weddingDate, IPlayer player) {
        this.date = date;
        this.spouse = spouse;
        this.weddingDate = weddingDate;
        this.player = player;
    }

    public static MarriageAnnouncementStateBuilder builder() {
        return new MarriageAnnouncementStateBuilder();
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public ISpouseData getSpouse() {
        return this.spouse;
    }

    public LocalDateTime getWeddingDate() {
        return this.weddingDate;
    }

    public IPlayer getPlayer() {
        return this.player;
    }

    public static class MarriageAnnouncementStateBuilder {
        private LocalDateTime date;
        private ISpouseData spouse;
        private LocalDateTime weddingDate;
        private IPlayer player;

        MarriageAnnouncementStateBuilder() {
        }

        public MarriageAnnouncementStateBuilder date(LocalDateTime date) {
            this.date = date;
            return this;
        }

        public MarriageAnnouncementStateBuilder spouse(ISpouseData spouse) {
            this.spouse = spouse;
            return this;
        }

        public MarriageAnnouncementStateBuilder weddingDate(LocalDateTime weddingDate) {
            this.weddingDate = weddingDate;
            return this;
        }

        public MarriageAnnouncementStateBuilder player(IPlayer player) {
            this.player = player;
            return this;
        }

        public MarriageAnnouncementState build() {
            return new MarriageAnnouncementState(this.date, this.spouse, this.weddingDate, this.player);
        }

        public String toString() {
            return "MarriageAnnouncementState.MarriageAnnouncementStateBuilder(date=" + this.date + ", spouse=" + this.spouse + ", weddingDate=" + this.weddingDate + ", player=" + this.player + ")";
        }
    }
}

