/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class MarriageOfferState
implements IDialogState {
    private LocalDateTime date;
    private String location;
    private IPlayer player;
    private ISpouseData spouse;
    private String fromFirstName;
    private String fromLastName;
    private LocalDateTime tillDate;

    public String getDialogBeanName() {
        return "marriageOfferDialog";
    }

    MarriageOfferState(LocalDateTime date, String location, IPlayer player, ISpouseData spouse, String fromFirstName, String fromLastName, LocalDateTime tillDate) {
        this.date = date;
        this.location = location;
        this.player = player;
        this.spouse = spouse;
        this.fromFirstName = fromFirstName;
        this.fromLastName = fromLastName;
        this.tillDate = tillDate;
    }

    public static MarriageOfferStateBuilder builder() {
        return new MarriageOfferStateBuilder();
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public String getLocation() {
        return this.location;
    }

    public IPlayer getPlayer() {
        return this.player;
    }

    public ISpouseData getSpouse() {
        return this.spouse;
    }

    public String getFromFirstName() {
        return this.fromFirstName;
    }

    public String getFromLastName() {
        return this.fromLastName;
    }

    public LocalDateTime getTillDate() {
        return this.tillDate;
    }

    public static class MarriageOfferStateBuilder {
        private LocalDateTime date;
        private String location;
        private IPlayer player;
        private ISpouseData spouse;
        private String fromFirstName;
        private String fromLastName;
        private LocalDateTime tillDate;

        MarriageOfferStateBuilder() {
        }

        public MarriageOfferStateBuilder date(LocalDateTime date) {
            this.date = date;
            return this;
        }

        public MarriageOfferStateBuilder location(String location) {
            this.location = location;
            return this;
        }

        public MarriageOfferStateBuilder player(IPlayer player) {
            this.player = player;
            return this;
        }

        public MarriageOfferStateBuilder spouse(ISpouseData spouse) {
            this.spouse = spouse;
            return this;
        }

        public MarriageOfferStateBuilder fromFirstName(String fromFirstName) {
            this.fromFirstName = fromFirstName;
            return this;
        }

        public MarriageOfferStateBuilder fromLastName(String fromLastName) {
            this.fromLastName = fromLastName;
            return this;
        }

        public MarriageOfferStateBuilder tillDate(LocalDateTime tillDate) {
            this.tillDate = tillDate;
            return this;
        }

        public MarriageOfferState build() {
            return new MarriageOfferState(this.date, this.location, this.player, this.spouse, this.fromFirstName, this.fromLastName, this.tillDate);
        }

        public String toString() {
            return "MarriageOfferState.MarriageOfferStateBuilder(date=" + this.date + ", location=" + this.location + ", player=" + this.player + ", spouse=" + this.spouse + ", fromFirstName=" + this.fromFirstName + ", fromLastName=" + this.fromLastName + ", tillDate=" + this.tillDate + ")";
        }
    }
}

