/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.factory;

import ch.sahits.game.openpatrician.model.player.IAIBuyWeaponStrategyType;
import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIConstructionSelectionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIHireSailorsStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIHireTradeManagerStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIShipUpgradeStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIStrategyProvider;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategyType;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class AIStrategyLoader {
    @ListType(value=IAIStrategyProvider.class)
    @Autowired(required=false)
    private List<IAIStrategyProvider> aiStrategyProviders;

    public List<IAITradeStrategyType> getTradeStrategies() {
        ArrayList<IAITradeStrategyType> tradeStrategies = new ArrayList<IAITradeStrategyType>();
        if (this.aiStrategyProviders != null) {
            for (IAIStrategyProvider provider : this.aiStrategyProviders) {
                tradeStrategies.addAll(provider.getTradeStrategies());
            }
        }
        return tradeStrategies;
    }

    public List<IAIShipRepairStrategyType> getRepairStrategies() {
        ArrayList<IAIShipRepairStrategyType> repairStrategies = new ArrayList<IAIShipRepairStrategyType>();
        for (IAIStrategyProvider provider : this.aiStrategyProviders) {
            repairStrategies.addAll(provider.getRepairStrategies());
        }
        return repairStrategies;
    }

    public List<IAITakeLoanStrategyType> getTakeLoanStrategies() {
        ArrayList<IAITakeLoanStrategyType> takeLoanStrategies = new ArrayList<IAITakeLoanStrategyType>();
        for (IAIStrategyProvider provider : this.aiStrategyProviders) {
            takeLoanStrategies.addAll(provider.getTakeLoanStrategies());
        }
        return takeLoanStrategies;
    }

    public List<IAIConstructionSelectionStrategyType> getConstructionSelectionStrategies() {
        ArrayList<IAIConstructionSelectionStrategyType> constructionSelectionStrategies = new ArrayList<IAIConstructionSelectionStrategyType>();
        for (IAIStrategyProvider provider : this.aiStrategyProviders) {
            constructionSelectionStrategies.addAll(provider.getConstructionSelectionStrategies());
        }
        return constructionSelectionStrategies;
    }

    public List<IAICaptainHireStrategyType> getCaptainHireStrategies() {
        ArrayList<IAICaptainHireStrategyType> captainHireStrategies = new ArrayList<IAICaptainHireStrategyType>();
        for (IAIStrategyProvider provider : this.aiStrategyProviders) {
            captainHireStrategies.addAll(provider.getCaptainHireStrategies());
        }
        return captainHireStrategies;
    }

    public List<IAIGuildJoinStrategyType> getGuildJoinStrategies() {
        ArrayList<IAIGuildJoinStrategyType> joinStrategies = new ArrayList<IAIGuildJoinStrategyType>();
        for (IAIStrategyProvider provider : this.aiStrategyProviders) {
            joinStrategies.addAll(provider.getGuildJoinStrategies());
        }
        return joinStrategies;
    }

    public List<IAIEventDecisionStrategyType> getEventDecisionStrategies() {
        ArrayList<IAIEventDecisionStrategyType> eventDecissionStrategies = new ArrayList<IAIEventDecisionStrategyType>();
        for (IAIStrategyProvider provider : this.aiStrategyProviders) {
            eventDecissionStrategies.addAll(provider.getEventDecisionStrategies());
        }
        return eventDecissionStrategies;
    }

    public List<IAIHireTradeManagerStrategyType> getHireTradeManagerStrategies() {
        ArrayList<IAIHireTradeManagerStrategyType> hireTradeManagerStrategies = new ArrayList<IAIHireTradeManagerStrategyType>();
        for (IAIStrategyProvider provider : this.aiStrategyProviders) {
            hireTradeManagerStrategies.addAll(provider.getHireTradeManagerStrategies());
        }
        return hireTradeManagerStrategies;
    }

    public List<IAIBuyWeaponStrategyType> getWeaponBuyStrategies() {
        ArrayList<IAIBuyWeaponStrategyType> buyWeaponStrategies = new ArrayList<IAIBuyWeaponStrategyType>();
        for (IAIStrategyProvider provider : this.aiStrategyProviders) {
            buyWeaponStrategies.addAll(provider.getWeaponBuyStrategies());
        }
        return buyWeaponStrategies;
    }

    public List<IAIHireSailorsStrategyType> getHireSailorStrategies() {
        ArrayList<IAIHireSailorsStrategyType> hireSailorsStrategies = new ArrayList<IAIHireSailorsStrategyType>();
        for (IAIStrategyProvider provider : this.aiStrategyProviders) {
            hireSailorsStrategies.addAll(provider.getHireSailorStrategies());
        }
        return hireSailorsStrategies;
    }

    public List<IAIShipUpgradeStrategyType> getShipUpgradeStrategies() {
        ArrayList<IAIShipUpgradeStrategyType> shipUpgradeStrategies = new ArrayList<IAIShipUpgradeStrategyType>();
        for (IAIStrategyProvider provider : this.aiStrategyProviders) {
            shipUpgradeStrategies.addAll(provider.getShipUpgradeStrategies());
        }
        return shipUpgradeStrategies;
    }
}

