/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.factory;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.IBowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.ICrossbowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.IMusketeer;
import ch.sahits.game.openpatrician.model.city.cityhall.IPikemen;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Bowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Crossbowmen;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Musketeer;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Pikemen;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.people.INonFreeSeaPirate;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.NonFreeSeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.server.IMapLocationProviderFacade;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.spring.DependentAnnotationConfigApplicationContext;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class PeopleFactory {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private IMapLocationProviderFacade locationProvider;
    @Autowired
    private Date date;
    @Autowired
    private SeaPiratesState piratesState;

    public ICaptain createNewCaptainProperty() {
        return (ICaptain)this.context.getBean(ICaptain.class);
    }

    public IContractBroker createNewContractBroker(AmountablePrice<IWare> amountable, IWare ware) {
        return (IContractBroker)this.context.getBean("contractBrookerState", new Object[]{amountable, ware});
    }

    public IBowmen createBowman() {
        return (IBowmen)this.context.getBean(Bowmen.class);
    }

    public ICrossbowmen createCrossbowman() {
        return (ICrossbowmen)this.context.getBean(Crossbowmen.class);
    }

    public IPikemen createPikeman() {
        return (IPikemen)this.context.getBean(Pikemen.class);
    }

    public IMusketeer createMusketeer() {
        return (IMusketeer)this.context.getBean(Musketeer.class);
    }

    public INonFreeSeaPirate createNewPirate(String name, IShip ship, IPlayer hiree, ICity nearCity) {
        NonFreeSeaPirate pirate = (NonFreeSeaPirate)this.context.getBean("nonFreeSeaPirate", new Object[]{hiree, this.date.getCurrentDate(), nearCity});
        pirate.setName(name);
        pirate.setShip((INavigableVessel)ship);
        Point2D p = nearCity != null ? this.locationProvider.getRandomPointAtSeaNear(nearCity.getCoordinates()) : this.locationProvider.getRandomPointAtSea();
        pirate.getShip().setLocation(p);
        return pirate;
    }

    public ISeaPirate createNewPirate(String name, INavigableVessel ship) {
        SeaPirate pirate = (SeaPirate)this.context.getBean(SeaPirate.class);
        pirate.setName(name);
        pirate.setShip(ship);
        Point2D p = this.locationProvider.getRandomPointAtSea();
        pirate.getShip().setLocation(p);
        return pirate;
    }

    public void free(INonFreeSeaPirate pirate) {
        ISeaPirate freePirate = this.createNewPirate(pirate.getName(), pirate.getShip());
        ((DependentAnnotationConfigApplicationContext)this.context).removePrototypeBean((Object)pirate);
        this.piratesState.replace(pirate, freePirate);
    }
}

