/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.task;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.CelebrationState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.CelebrationSuccess;
import ch.sahits.game.openpatrician.clientserverinterface.service.CelebrationService;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.model.ui.TargetedDialogStateWrapper;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CelebrationTask
extends TimedTask {
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private CelebrationService celebrationService;
    private final IPlayer player;
    private final ICity city;

    public void run() {
        CelebrationState state = this.calculateCelebrationState();
        TargetedDialogStateWrapper wrapper = new TargetedDialogStateWrapper(this.player, (IDialogState)state);
        this.clientServerEventBus.post((Object)wrapper);
        this.updateReputation(state);
    }

    private void updateReputation(CelebrationState state) {
        if (state.getSuccess() == CelebrationSuccess.HIT) {
            this.city.getReputation(this.player).update(700);
        } else if (state.getSuccess() == CelebrationSuccess.SUCCESS) {
            this.city.getReputation(this.player).update(400);
        }
    }

    private CelebrationState calculateCelebrationState() {
        Map<EPopulationClass, Integer> nbGuests = this.celebrationService.calculateAttendees(this.city, this.player);
        Map<IWare, Integer> requiredAmount = this.celebrationService.calculateRequiredAmounts(nbGuests);
        Map<IWare, Double> missingPercentage = this.celebrationService.calculateMissingWares(requiredAmount, this.player, this.city);
        double avgMissing = missingPercentage.values().stream().mapToDouble(val -> val).sum() / (double)missingPercentage.size();
        CelebrationSuccess success = this.calculateSuccess(avgMissing);
        Optional optOffice = this.player.findTradingOffice(this.city);
        if (optOffice.isPresent()) {
            ITradingOffice tradingOffice = (ITradingOffice)optOffice.get();
            for (IWare ware : requiredAmount.keySet()) {
                int amount = requiredAmount.get(ware);
                tradingOffice.move(ware, -amount, 0);
            }
        }
        int attendance = nbGuests.values().stream().mapToInt(val -> val).sum();
        return this.createCelebrationState(success, attendance);
    }

    protected CelebrationState createCelebrationState(CelebrationSuccess success, int attendance) {
        return CelebrationState.builder().date(this.date.getCurrentDate()).amountGuests(attendance).location(this.city.getName()).success(success).build();
    }

    private CelebrationSuccess calculateSuccess(double avgMissing) {
        CelebrationSuccess success = CelebrationSuccess.FAILURE;
        if (avgMissing <= 0.0) {
            success = CelebrationSuccess.HIT;
        } else if (avgMissing < 0.15) {
            success = CelebrationSuccess.SUCCESS;
        } else if (avgMissing < 0.3) {
            success = CelebrationSuccess.FLOP;
        }
        return success;
    }

    public CelebrationTask(IPlayer player, ICity city) {
        this.player = player;
        this.city = city;
    }

    protected IPlayer getPlayer() {
        return this.player;
    }

    protected ICity getCity() {
        return this.city;
    }
}

