/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CelebrationService {
    @Autowired
    private Random rnd;

    public Map<EPopulationClass, Integer> calculateAttendees(ICity city, IPlayer player) {
        int population = 0;
        HashMap<EPopulationClass, Integer> nbGuests = new HashMap<EPopulationClass, Integer>();
        for (EPopulationClass ePopulationClass : EPopulationClass.values()) {
            population += city.getPopulation(ePopulationClass);
            nbGuests.put(ePopulationClass, 0);
        }
        int amountBeggarsInCity = city.getPopulation(EPopulationClass.BEGGAR);
        nbGuests.put(EPopulationClass.BEGGAR, amountBeggarsInCity);
        if (population > 3000 && amountBeggarsInCity < 50) {
            int attractedBeggers = this.rnd.nextInt(70);
            city.setPopulation(attractedBeggers, EPopulationClass.BEGGAR);
            nbGuests.put(EPopulationClass.BEGGAR, amountBeggarsInCity + attractedBeggers);
        }
        int amountPoorInCity = city.getPopulation(EPopulationClass.POOR);
        int amountMediumInCity = city.getPopulation(EPopulationClass.MEDIUM);
        int amountRichInCity = city.getPopulation(EPopulationClass.RICH);
        switch (player.getRank()) {
            case CHANDLER: {
                nbGuests.put(EPopulationClass.POOR, (int)((double)amountPoorInCity * 0.4));
                nbGuests.put(EPopulationClass.MEDIUM, (int)((double)amountMediumInCity * 0.06));
                break;
            }
            case BARGAINER: {
                nbGuests.put(EPopulationClass.POOR, (int)((double)amountPoorInCity * 0.5));
                nbGuests.put(EPopulationClass.MEDIUM, (int)((double)amountMediumInCity * 0.12));
                break;
            }
            case MERCHANT: {
                nbGuests.put(EPopulationClass.POOR, (int)((double)amountPoorInCity * 0.5));
                nbGuests.put(EPopulationClass.MEDIUM, (int)((double)amountMediumInCity * 0.2));
                nbGuests.put(EPopulationClass.RICH, (int)((double)amountRichInCity * 0.1));
                break;
            }
            case TRADESMAN: {
                nbGuests.put(EPopulationClass.POOR, (int)((double)amountPoorInCity * 0.4));
                nbGuests.put(EPopulationClass.MEDIUM, (int)((double)amountMediumInCity * 0.6));
                nbGuests.put(EPopulationClass.RICH, (int)((double)amountRichInCity * 0.3));
                break;
            }
            case COUNCILMAN: {
                nbGuests.put(EPopulationClass.POOR, (int)((double)amountPoorInCity * 0.4));
                nbGuests.put(EPopulationClass.MEDIUM, (int)((double)amountMediumInCity * 0.5));
                nbGuests.put(EPopulationClass.RICH, (int)((double)amountRichInCity * 0.5));
                break;
            }
            case PATRICIAN: {
                nbGuests.put(EPopulationClass.POOR, (int)((double)amountPoorInCity * 0.5));
                nbGuests.put(EPopulationClass.MEDIUM, (int)((double)amountMediumInCity * 0.7));
                nbGuests.put(EPopulationClass.RICH, (int)((double)amountRichInCity * 0.6));
                break;
            }
            case MAYOR: {
                nbGuests.put(EPopulationClass.POOR, (int)((double)amountPoorInCity * 0.8));
                nbGuests.put(EPopulationClass.MEDIUM, (int)((double)amountMediumInCity * 0.7));
                nbGuests.put(EPopulationClass.RICH, (int)((double)amountRichInCity * 0.9));
                break;
            }
            case ALDERMAN: {
                nbGuests.put(EPopulationClass.POOR, amountPoorInCity);
                nbGuests.put(EPopulationClass.MEDIUM, amountMediumInCity);
                nbGuests.put(EPopulationClass.RICH, amountRichInCity);
            }
        }
        return nbGuests;
    }

    public Map<IWare, Integer> calculateRequiredAmounts(Map<EPopulationClass, Integer> nbGuests) {
        HashMap<IWare, Integer> requiredAmount = new HashMap<IWare, Integer>();
        requiredAmount.put((IWare)EWare.MEAT, 0);
        requiredAmount.put((IWare)EWare.FISH, 0);
        requiredAmount.put((IWare)EWare.WINE, 0);
        requiredAmount.put((IWare)EWare.HONEY, 0);
        double amount = 10.0 * ((double)nbGuests.get(EPopulationClass.BEGGAR).intValue() / 1000.0) * 2.0;
        amount += 10.0 * ((double)nbGuests.get(EPopulationClass.POOR).intValue() / 1000.0);
        amount += 10.0 * ((double)nbGuests.get(EPopulationClass.MEDIUM).intValue() / 1000.0);
        requiredAmount.put((IWare)EWare.BEER, (int)Math.ceil(amount += 10.0 * ((double)nbGuests.get(EPopulationClass.RICH).intValue() / 1000.0) * 0.5));
        amount = 1.5 * ((double)nbGuests.get(EPopulationClass.BEGGAR).intValue() / 1000.0) * 2.0;
        amount += 1.5 * ((double)nbGuests.get(EPopulationClass.POOR).intValue() / 1000.0);
        amount += 1.5 * ((double)nbGuests.get(EPopulationClass.MEDIUM).intValue() / 1000.0);
        requiredAmount.put((IWare)EWare.GRAIN, (int)Math.ceil(amount += 1.5 * ((double)nbGuests.get(EPopulationClass.RICH).intValue() / 1000.0)));
        amount = 1.0 * ((double)nbGuests.get(EPopulationClass.BEGGAR).intValue() / 1000.0) * 2.0;
        amount += 1.0 * ((double)nbGuests.get(EPopulationClass.POOR).intValue() / 1000.0);
        amount += 1.0 * ((double)nbGuests.get(EPopulationClass.MEDIUM).intValue() / 1000.0) * 1.5;
        requiredAmount.put((IWare)EWare.MEAT, (int)Math.ceil(amount += 1.0 * ((double)nbGuests.get(EPopulationClass.RICH).intValue() / 1000.0) * 2.0));
        amount = 1.0 * ((double)nbGuests.get(EPopulationClass.BEGGAR).intValue() / 1000.0) * 3.0;
        amount += 1.0 * ((double)nbGuests.get(EPopulationClass.POOR).intValue() / 1000.0);
        amount += 1.0 * ((double)nbGuests.get(EPopulationClass.MEDIUM).intValue() / 1000.0) * 0.8;
        requiredAmount.put((IWare)EWare.FISH, (int)Math.ceil(amount += 1.0 * ((double)nbGuests.get(EPopulationClass.RICH).intValue() / 1000.0) * 0.3));
        amount = 10.0 * ((double)nbGuests.get(EPopulationClass.BEGGAR).intValue() / 1000.0) * 0.7;
        amount += 10.0 * ((double)nbGuests.get(EPopulationClass.POOR).intValue() / 1000.0) * 1.2;
        amount += 10.0 * ((double)nbGuests.get(EPopulationClass.MEDIUM).intValue() / 1000.0) * 1.8;
        requiredAmount.put((IWare)EWare.WINE, (int)Math.ceil(amount += 10.0 * ((double)nbGuests.get(EPopulationClass.RICH).intValue() / 1000.0) * 2.0));
        amount = 5.0 * ((double)nbGuests.get(EPopulationClass.BEGGAR).intValue() / 1000.0);
        amount += 5.0 * ((double)nbGuests.get(EPopulationClass.POOR).intValue() / 1000.0);
        amount += 5.0 * ((double)nbGuests.get(EPopulationClass.MEDIUM).intValue() / 1000.0);
        requiredAmount.put((IWare)EWare.HONEY, (int)Math.ceil(amount += 5.0 * ((double)nbGuests.get(EPopulationClass.RICH).intValue() / 1000.0) * 1.2));
        return requiredAmount;
    }

    public Map<IWare, Double> calculateMissingWares(Map<IWare, Integer> requiredAmount, IPlayer player, ICity city) {
        Optional optOffice = player.findTradingOffice(city);
        HashMap<IWare, Double> missingWares = new HashMap<IWare, Double>();
        if (!optOffice.isPresent()) {
            for (IWare ware : requiredAmount.keySet()) {
                missingWares.put(ware, 1.0);
            }
            return missingWares;
        }
        for (IWare ware : requiredAmount.keySet()) {
            double required = requiredAmount.get(ware).intValue();
            int available = 0;
            available = ((ITradingOffice)optOffice.get()).getWare(ware).getAmount();
            if ((double)available >= required) {
                missingWares.put(ware, 0.0);
                continue;
            }
            if (available == 0) {
                missingWares.put(ware, 1.0);
                continue;
            }
            double percentage = (double)available / required;
            missingWares.put(ware, percentage);
        }
        return missingWares;
    }
}

