/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import org.springframework.stereotype.Service;

@Service
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class DialogTemplateFactory {
    public DialogTemplate createDialogTemplate(EDialogTemplateType templateType, DialogTemplateParameterSupplier supplier) {
        switch (templateType) {
            case ESCORT_LEAVES_SHIP_AFTER_DEADLINE: {
                return this.createUnsuccessfulEscort(supplier);
            }
            case ESCORT_LEAVES_SHIP_BEFORE_DEADLINE: {
                return this.createSuccessfulEscort(supplier);
            }
            case FUGITIVE_LEAVES_SHIP_AFTER_DEADLINE: {
                return this.createUnsuccessfulFugative(supplier);
            }
            case FUGITIVE_LEAVES_SHIP_BEFORE_DEADLINE: {
                return this.createSuccessfulFugative(supplier);
            }
            case TRAVELER_LEAVES_SHIP_AFTER_DEADLINE: {
                return this.createUnsuccessfulTraveler(supplier);
            }
            case TRAVELER_LEAVES_SHIP_BEFORE_DEADLINE: {
                return this.createSuccessfulTraveler(supplier);
            }
            case COURIER_SERVICE_FINISHED_UNSUCCESSFUL: {
                return this.createUnsuccessfulCourier(supplier);
            }
            case COURIER_SERVICE_FINISHED_SUCCESSFUL: {
                return this.createSuccessfulCourier(supplier);
            }
            case CAPTAIN_UPGRADE: {
                return this.createCaptainUpgrade(supplier);
            }
            case STEWARD_UPGRADE: {
                return this.createStewardUpgrade(supplier);
            }
            case FIRE_FINISHED: {
                return this.createFireEnded(supplier);
            }
            case PLAGUE_END: {
                return this.createPlaugeEnded(supplier);
            }
        }
        throw new IllegalArgumentException("No implementation for " + templateType);
    }

    private DialogTemplate createStewardUpgrade(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.openpatrician.model.building.impl.Steward.title";
        String messageKey = "ch.sahits.game.openpatrician.model.building.impl.Steward.text";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }

    private DialogTemplate createCaptainUpgrade(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.openpatrician.model.people.impl.CaptainState.captainUpgrade.title";
        String messageKey = "ch.sahits.game.openpatrician.model.people.impl.CaptainState.captainUpgrade.text";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }

    private DialogTemplate createSuccessfulEscort(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.dialogTemplate.leaving.successful.title";
        String messageKey = "ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.dialogTemplate.leaving.successful.message";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }

    private DialogTemplate createUnsuccessfulEscort(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.dialogTemplate.leaving.unsuccessful.title";
        String messageKey = "ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.dialogTemplate.leaving.unsuccessful.message";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }

    private DialogTemplate createSuccessfulFugative(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.dialogTemplate.leaving.successful.title";
        String messageKey = "ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.dialogTemplate.leaving.successful.message";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }

    private DialogTemplate createUnsuccessfulFugative(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.dialogTemplate.leaving.unsuccessful.title";
        String messageKey = "ch.sahits.game.openpatrician.display.dialog.TavernFugitiveDialog.dialogTemplate.leaving.unsuccessful.message";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }

    private DialogTemplate createSuccessfulTraveler(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.openpatrician.display.dialog.TavernTravelerDialog.dialogTemplate.leaving.successful.title";
        String messageKey = "ch.sahits.game.openpatrician.display.dialog.TavernTravelerDialog.dialogTemplate.leaving.successful.message";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }

    private DialogTemplate createUnsuccessfulTraveler(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.openpatrician.display.dialog.TavernTravelerDialog.dialogTemplate.leaving.unsuccessful.title";
        String messageKey = "ch.sahits.game.openpatrician.display.dialog.TavernTravelerDialog.dialogTemplate.leaving.unsuccessful.message";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }

    private DialogTemplate createSuccessfulCourier(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.event.handler.impl.NextCourierPatrolStation.dialogTemplate.leaving.successful.title";
        String messageKey = "ch.sahits.game.event.handler.impl.NextCourierPatrolStation.dialogTemplate.leaving.successful.message";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }

    private DialogTemplate createUnsuccessfulCourier(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.event.handler.impl.NextCourierPatrolStation.dialogTemplate.leaving.unsuccessful.title";
        String messageKey = "ch.sahits.game.event.handler.impl.NextCourierPatrolStation.dialogTemplate.leaving.unsuccessful.message";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }

    private DialogTemplate createFireEnded(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.openpatrician.engine.event.EventEngine.fire.result.title";
        String messageKey = "ch.sahits.game.openpatrician.engine.event.EventEngine.fire.result.description";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }

    private DialogTemplate createPlaugeEnded(DialogTemplateParameterSupplier supplier) {
        String titleKey = "ch.sahits.game.openpatrician.engine.event.EventEngine.plague.result.title";
        String messageKey = "ch.sahits.game.openpatrician.engine.event.EventEngine.plague.result.description";
        DialogTemplate template = DialogTemplate.builder().closable(true).titleKey(titleKey).messageKey(messageKey).messageArgs(supplier.get()).build();
        return template;
    }
}

