/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ISteward;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.javafx.bindings.ConstantIntegerBinding;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TradeService {
    @Autowired
    private ComputablePriceV2 computablePrice;
    @Autowired
    private PopulationConsume consume;
    @Autowired
    private DialogTemplateFactory dialogTemplateFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    protected AsyncEventBus clientServerEventBus;
    @MapType(key=Integer.class, value=Integer.class)
    private static final Map<Integer, Integer> UPGRADE_LIMIT_LEVEL = new HashMap<Integer, Integer>();
    @ListType(value=IWare.class)
    private List<IWare> basicNeeds;

    @PostConstruct
    private void initialize() {
        this.basicNeeds = this.getBasicNeededWares();
    }

    private List<IWare> getBasicNeededWares() {
        ArrayList<IWare> requiredWares = new ArrayList<IWare>();
        for (EWare ware : EWare.values()) {
            double sum = 0.0;
            for (EPopulationClass populationClass : EPopulationClass.values()) {
                sum += this.consume.getNeed((IWare)ware, populationClass, 1000);
            }
            if (!(sum > 0.0)) continue;
            requiredWares.add((IWare)ware);
        }
        return requiredWares;
    }

    public List<IWare> getBasicNeeds() {
        return this.basicNeeds;
    }

    public void transferFromVesselToStorage(INavigableVessel vessel, IPlayer player, ICity city, Map<IWare, Integer> amounts) {
        Optional optOffice = player.findTradingOffice(city);
        Preconditions.checkArgument((boolean)optOffice.isPresent(), (Object)("There is no trading office for " + player.getName() + " " + player.getLastName() + " in " + city.getName()));
        for (IWare ware : amounts.keySet()) {
            int amount = amounts.get(ware);
            int avgPrice = vessel.getWare(ware).getAVGPrice();
            amount = vessel.unload(ware, amount);
            ((ITradingOffice)optOffice.get()).move(ware, amount, avgPrice);
            if (!(vessel instanceof IConvoy)) continue;
            this.distributeIncomeToConvoyParticipants((IConvoy)vessel, player, avgPrice, amount);
        }
    }

    public int transferFromStorageToVessel(ITradingOffice office, INavigableVessel vessel, IPlayer player, IWare ware, int amount) {
        AmountablePrice amountable = office.getWare(ware);
        int avgPrice = amountable.getAVGPrice();
        int moved = office.move(ware, -amount, avgPrice);
        moved = vessel.load(ware, moved, avgPrice);
        if (vessel instanceof IConvoy) {
            this.distributeCostToConvoyParticipants((IConvoy)vessel, player, avgPrice, moved);
        }
        return moved;
    }

    public int sellFromStorageToCity(ITradingOffice office, IPlayer player, ICity city, IWare ware, int amount, Optional<Integer> minAvgPrice) {
        int availableAmountCity = city.getWare(ware).getAmount();
        int amountToBeSold = amount;
        if (minAvgPrice.isPresent()) {
            amountToBeSold = this.computablePrice.calculateSellAmount((ITradable)ware, availableAmountCity, minAvgPrice.get().intValue(), amount);
        }
        int avgPrice = this.computablePrice.sellPrice((ITradable)ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amountToBeSold));
        city.move(ware, amountToBeSold, (ICitizen)player);
        int sold = office.move(ware, -amountToBeSold, avgPrice);
        if (player instanceof IHumanPlayer) {
            player.getCompany().updateCash((long)(avgPrice * sold));
        } else {
            player.getCompany().updateCashDirectly((long)(avgPrice * sold));
        }
        return avgPrice * sold;
    }

    public void sellWareShipToCity(INavigableVessel vessel, IPlayer player, ICity city, IWare ware, int amount, Optional<Integer> minAvgPrice) {
        int availableAmountCity = city.getWare(ware).getAmount();
        int amountToBeSold = amount;
        if (minAvgPrice.isPresent()) {
            amountToBeSold = this.computablePrice.calculateSellAmount((ITradable)ware, availableAmountCity, minAvgPrice.get().intValue(), amount);
        }
        if (amountToBeSold > 0) {
            int avgPrice = this.computablePrice.sellPrice((ITradable)ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amountToBeSold));
            city.move(ware, amountToBeSold, (ICitizen)player);
            int sold = vessel.unload(ware, amountToBeSold);
            if (vessel instanceof IShip) {
                if (player instanceof IHumanPlayer) {
                    player.getCompany().updateCash((long)(avgPrice * sold));
                } else {
                    player.getCompany().updateCashDirectly((long)(avgPrice * sold));
                }
            } else {
                this.distributeIncomeToConvoyParticipants((IConvoy)vessel, avgPrice, sold);
            }
        }
    }

    public int buyFromCityToStorage(ITradingOffice office, IPlayer player, ICity city, IWare ware, int amount, Optional<Integer> avgPrice, Optional<ISteward> optSteward) {
        Pair<Integer, Integer> amountBought;
        ICompany company = player.getCompany();
        int availableAmountCity = city.getWare(ware).getAmount();
        if (availableAmountCity > 0 && (Integer)(amountBought = avgPrice.isPresent() ? this.buyWareFromCity(player, city, availableAmountCity, amount, avgPrice.get(), ware, company.getCash()) : this.buyWareFromCity(player, city, availableAmountCity, amount, ware, company.getCash())).getKey() > 0) {
            int loaded = office.move(ware, ((Integer)amountBought.getKey()).intValue(), ((Integer)amountBought.getValue()).intValue());
            double discountBonus = 1.0;
            int costsWithoutDiscount = -((Integer)amountBought.getValue()).intValue() * loaded;
            if (optSteward.isPresent()) {
                ISteward steward = optSteward.get();
                discountBonus = this.calculateExperianceBonusFactor(steward.getExpertiseLevel());
                int profit = (int)Math.rint((double)costsWithoutDiscount * (discountBonus - 1.0));
                steward.updateProfit(profit);
                if (steward.getTotalProfit() > UPGRADE_LIMIT_LEVEL.get(steward.getExpertiseLevel())) {
                    steward.upgradeToNextLevel();
                    if (player instanceof IHumanPlayer) {
                        DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{city.getName(), steward.getSalary()});
                        DialogTemplate template = this.dialogTemplateFactory.createDialogTemplate(EDialogTemplateType.STEWARD_UPGRADE, parameterSupplier);
                        DisplayTemplateMessage message = new DisplayTemplateMessage("ch.sahits.game.openpatrician.model.building.impl.Steward.title", template, new Object[0]);
                        TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)player, (Object)message);
                        this.clientServerEventBus.post((Object)tagetDisplayMsg);
                    }
                }
            }
            int costs = (int)Math.rint((double)costsWithoutDiscount * discountBonus);
            if (player instanceof IHumanPlayer) {
                company.updateCash((long)costs);
            } else {
                company.updateCashDirectly((long)costs);
            }
            return costs;
        }
        return 0;
    }

    public void buyFromCityToShip(INavigableVessel vessel, IPlayer player, ICity city, IWare ware, int amount, Optional<Integer> maxAvgPrice, Optional<ICaptain> optCaptain) {
        ICompany company = player.getCompany();
        int availableAmountCity = city.getWare(ware).getAmount();
        if (availableAmountCity > 0) {
            Pair<Integer, Integer> amountBought;
            long cash = company.getCash();
            if (vessel instanceof IConvoy) {
                IConvoy convoy = (IConvoy)vessel;
                cash = convoy.getPlayers().stream().mapToLong(p -> p.getCompany().getCash()).sum();
            }
            if ((Integer)(amountBought = maxAvgPrice.isPresent() ? this.buyWareFromCity(player, city, availableAmountCity, amount, maxAvgPrice.get(), ware, cash) : this.buyWareFromCity(player, city, availableAmountCity, amount, ware, cash)).getKey() > 0) {
                int loaded = vessel.load(ware, ((Integer)amountBought.getKey()).intValue(), ((Integer)amountBought.getValue()).intValue());
                double discountBonus = 1.0;
                int costsWithoutDiscount = -((Integer)amountBought.getValue()).intValue() * loaded;
                if (optCaptain.isPresent()) {
                    ICaptain captain = optCaptain.get();
                    discountBonus = this.calculateExperianceBonusFactor(captain.getTradingSkillLevel());
                    int profit = (int)Math.rint((double)costsWithoutDiscount * (discountBonus - 1.0));
                    captain.updateProfit(profit);
                    if (captain.upgradeToNextTradeLevel()) {
                        DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{captain.getName(), vessel.getName(), captain.getSalary()});
                        DialogTemplate template = this.dialogTemplateFactory.createDialogTemplate(EDialogTemplateType.CAPTAIN_UPGRADE, parameterSupplier);
                        DisplayTemplateMessage message = new DisplayTemplateMessage("ch.sahits.game.openpatrician.model.people.impl.CaptainState.captainUpgrade.title", template, new Object[0]);
                        TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)player, (Object)message);
                        this.clientServerEventBus.post((Object)tagetDisplayMsg);
                    }
                }
                if (vessel instanceof IConvoy) {
                    this.distributeCostsToAllConvoyParticipants((IConvoy)vessel, amountBought, loaded, discountBonus);
                } else {
                    company.updateCash((long)Math.rint((double)costsWithoutDiscount * discountBonus));
                }
            }
        }
    }

    private Pair<Integer, Integer> buyWareFromCity(IPlayer player, ICity city, int availableAmountCity, int amount, IWare ware, long cash) {
        int amountToBuy = Math.min(availableAmountCity, amount);
        return this.buyWareFromCity(player, city, availableAmountCity, ware, cash, amountToBuy, Integer.MAX_VALUE);
    }

    @VisibleForTesting
    Pair<Integer, Integer> buyWareFromCity(IPlayer player, ICity city, int availableAmountCity, int amount, int avgPrice, IWare ware, long cash) {
        int amountToBuy = Math.min(availableAmountCity, amount);
        return this.buyWareFromCity(player, city, availableAmountCity, ware, cash, amountToBuy, avgPrice);
    }

    private Pair<Integer, Integer> buyWareFromCity(IPlayer player, ICity city, int availableAmountCity, IWare ware, long cash, int amountToBuy, int maxAvgPrice) {
        Pair<Integer, Integer> affordable = this.calculateAffordableAmountToBuy(ware, cash, amountToBuy, availableAmountCity, maxAvgPrice);
        amountToBuy = (Integer)affordable.getKey();
        int avgPriceCompleteAmount = (Integer)affordable.getValue();
        if (amountToBuy == 0) {
            return new Pair((Object)0, (Object)0);
        }
        int movedAmount = city.move(ware, -amountToBuy, (ICitizen)player);
        if (amountToBuy != -movedAmount) {
            avgPriceCompleteAmount = this.computablePrice.buyPrice((ITradable)ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(city.getWare(ware).getAmount() + movedAmount), (IntegerBinding)new ConstantIntegerBinding(movedAmount));
            amountToBuy = -movedAmount;
        }
        return new Pair((Object)amountToBuy, (Object)avgPriceCompleteAmount);
    }

    private void distributeCostsToAllConvoyParticipants(IConvoy convoy, Pair<Integer, Integer> amountBougth, int loaded, double discountBonus) {
        Map capacityMap = convoy.getCapacityPerOwner();
        long totalPrice = (long)Math.rint((double)(-((Integer)amountBougth.getValue()).intValue() * loaded) * discountBonus);
        this.updatePlayerByCapacityPercentage(convoy, capacityMap, totalPrice);
    }

    private void distributeIncomeToConvoyParticipants(IConvoy vessel, int avgPrice, int sold) {
        Map capacityMap = vessel.getCapacityPerOwner();
        long totalCash = avgPrice * sold;
        this.updatePlayerByCapacityPercentage(vessel, capacityMap, totalCash);
    }

    private void distributeIncomeToConvoyParticipants(IConvoy convoy, IPlayer player, int avgPrice, int moved) {
        Map capacityMap = convoy.getCapacityPerOwner();
        capacityMap.remove(player);
        long totalCash = (long)Math.rint(avgPrice * moved);
        this.updatePlayerByCapacityPercentageRedistribution(player, convoy, capacityMap, totalCash);
    }

    private void distributeCostToConvoyParticipants(IConvoy convoy, IPlayer player, int avgPrice, int moved) {
        Map capacityMap = convoy.getCapacityPerOwner();
        capacityMap.remove(player);
        long totalCash = -avgPrice * moved;
        this.updatePlayerByCapacityPercentageRedistribution(player, convoy, capacityMap, totalCash);
    }

    private void updatePlayerByCapacityPercentageRedistribution(IPlayer player, IConvoy convoy, Map<IPlayer, Integer> capacityMap, long totalCash) {
        double totalCapacity = convoy.getCapacity();
        ICompany company = player.getCompany();
        for (Map.Entry<IPlayer, Integer> entry : capacityMap.entrySet()) {
            double percentage = (double)entry.getValue().intValue() / totalCapacity;
            long partialAmount = Math.round((double)totalCash * percentage);
            IPlayer player1 = entry.getKey();
            ICompany company1 = player1.getCompany();
            if (player1 instanceof IHumanPlayer) {
                company1.updateCash(partialAmount);
            } else {
                company1.updateCashDirectly(partialAmount);
            }
            if (player instanceof IHumanPlayer) {
                company.updateCash(-partialAmount);
                continue;
            }
            company.updateCashDirectly(-partialAmount);
        }
    }

    private void updatePlayerByCapacityPercentage(IConvoy convoy, Map<IPlayer, Integer> capacityMap, long totalCash) {
        double totalCapacity = convoy.getCapacity();
        for (Map.Entry<IPlayer, Integer> entry : capacityMap.entrySet()) {
            double percentage = (double)entry.getValue().intValue() / totalCapacity;
            long partialAmount = Math.round((double)totalCash * percentage);
            IPlayer player = entry.getKey();
            if (player instanceof IHumanPlayer) {
                player.getCompany().updateCash(partialAmount);
                continue;
            }
            player.getCompany().updateCashDirectly(partialAmount);
        }
    }

    @VisibleForTesting
    Pair<Integer, Integer> calculateAffordableAmountToBuy(IWare ware, long cash, int desiredAmount, int availableAmountCity, int maxAvgPrice) {
        int buyAmount = this.computablePrice.calculateBuyAmount((ITradable)ware, availableAmountCity, maxAvgPrice, desiredAmount, cash);
        if (buyAmount > 10) {
            --buyAmount;
        }
        if (buyAmount == 0) {
            return new Pair((Object)0, (Object)0);
        }
        int price = this.computablePrice.buyPrice((ITradable)ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(buyAmount));
        return new Pair((Object)buyAmount, (Object)price);
    }

    private double calculateExperianceBonusFactor(int experianceLevel) {
        return 0.95 - (double)experianceLevel * 0.05;
    }

    static {
        UPGRADE_LIMIT_LEVEL.put(0, 10000);
        UPGRADE_LIMIT_LEVEL.put(1, 20000);
        UPGRADE_LIMIT_LEVEL.put(2, 40000);
        UPGRADE_LIMIT_LEVEL.put(3, 70000);
        UPGRADE_LIMIT_LEVEL.put(4, 100000);
    }
}

